/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.dim;

import com.alibaba.ververica.connectors.common.exception.ConnectorException;
import com.alibaba.ververica.connectors.jdbc.dim.AllCacheLookupFunction;
import com.alibaba.ververica.connectors.jdbc.dim.VervericaJdbcLookupOptions;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VervericaJdbcAllCacheLookupFunction
extends AllCacheLookupFunction<RowData, RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(VervericaJdbcAllCacheLookupFunction.class);
    private final String scanTemplate;
    private final String drivername;
    private final String dbURL;
    private final String username;
    private final String password;
    private final DataType[] keyTypes;
    private final RowData.FieldGetter[] keyGetters;
    private final int[] keyIndices;
    private final String[] fieldNames;
    private final DataType[] fieldTypes;
    private final int maxRetryTimes;
    private final JdbcRowConverter jdbcRowConverter;
    private transient Connection connection;
    private transient PreparedStatement statement;

    public VervericaJdbcAllCacheLookupFunction(InternalJdbcConnectionOptions options, VervericaJdbcLookupOptions lookupOptions, String[] fieldNames, DataType[] fieldTypes, String[] keyNames, RowType rowType) {
        super(options.getTableName(), lookupOptions.getCacheExpireMs());
        Preconditions.checkNotNull((Object)options, (String)"No JdbcOptions supplied.");
        Preconditions.checkNotNull((Object)fieldNames, (String)"No fieldNames supplied.");
        Preconditions.checkNotNull((Object)fieldTypes, (String)"No fieldTypes supplied.");
        Preconditions.checkNotNull((Object)keyNames, (String)"No keyNames supplied.");
        this.drivername = options.getDriverName();
        this.dbURL = options.getDbURL();
        Preconditions.checkArgument((boolean)options.getUsername().isPresent());
        Preconditions.checkArgument((boolean)options.getPassword().isPresent());
        this.username = options.getUsername().get();
        this.password = options.getPassword().get();
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        List<String> nameList = Arrays.asList(fieldNames);
        this.keyGetters = new RowData.FieldGetter[keyNames.length];
        this.keyTypes = new DataType[keyNames.length];
        this.keyIndices = new int[keyNames.length];
        for (int i = 0; i < keyNames.length; ++i) {
            DataType keyType;
            Preconditions.checkArgument((boolean)nameList.contains(keyNames[i]), (String)"keyName %s can't find in fieldNames %s.", (Object[])new Object[]{keyNames[i], nameList});
            int keyIdx = nameList.indexOf(keyNames[i]);
            this.keyTypes[i] = keyType = fieldTypes[keyIdx];
            this.keyIndices[i] = keyIdx;
            this.keyGetters[i] = RowData.createFieldGetter((LogicalType)keyType.getLogicalType(), (int)keyIdx);
        }
        this.maxRetryTimes = lookupOptions.getMaxRetryTimes();
        String selectExpressions = Arrays.stream(fieldNames).map(options.getDialect()::quoteIdentifier).collect(Collectors.joining(", "));
        this.scanTemplate = "SELECT " + selectExpressions + " FROM " + options.getTableName();
        this.jdbcRowConverter = options.getDialect().getRowConverter(rowType);
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Arrays.asList(this.keyTypes);
    }

    @Override
    public DataType getOutputDataType() {
        return VervericaJdbcAllCacheLookupFunction.getRowDataType(this.fieldNames, this.fieldTypes);
    }

    @Override
    public void openConnection() {
        try {
            this.establishConnectionAndStatement();
        }
        catch (SQLException sqe) {
            throw new IllegalArgumentException("open() failed.", sqe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC driver class not found.", cnfe);
        }
    }

    @Override
    public void closeConnection() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                LOG.info("JDBC statement could not be closed: " + e.getMessage());
            }
            finally {
                this.statement = null;
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException se) {
                LOG.info("JDBC connection could not be closed: " + se.getMessage());
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public RowData geCacheKey(Object ... keys) {
        return GenericRowData.of((Object[])keys);
    }

    private static RowData getCacheKeyFromRowData(RowData row, RowData.FieldGetter[] fieldGetters) {
        GenericRowData keyRow = new GenericRowData(fieldGetters.length);
        for (int i = 0; i < fieldGetters.length; ++i) {
            keyRow.setField(i, fieldGetters[i].getFieldOrNull(row));
        }
        return keyRow;
    }

    @Override
    public void scanTable(Map<RowData, List<RowData>> tempCache) throws SQLException, ClassNotFoundException {
        for (int retry = 1; retry <= this.maxRetryTimes; ++retry) {
            try (ResultSet resultSet = this.statement.executeQuery();){
                while (resultSet.next()) {
                    RowData row = this.jdbcRowConverter.toInternal(resultSet);
                    RowData key = VervericaJdbcAllCacheLookupFunction.getCacheKeyFromRowData(row, this.keyGetters);
                    List<RowData> cache = tempCache.get(key);
                    if (cache != null) {
                        cache.add(row);
                        continue;
                    }
                    ArrayList<RowData> newCache = new ArrayList<RowData>();
                    newCache.add(row);
                    tempCache.put(key, newCache);
                }
                return;
            }
            catch (Throwable t) {
                ConnectorException exception = new ConnectorException("Error happens when scanning all data from table", t);
                if (t instanceof InterruptedException || t instanceof OutOfMemoryError) {
                    LOG.error("Error happens when scanning all data from table.", exception);
                    throw exception;
                }
                LOG.error(String.format("JDBC executeBatch error, retry times = %d", retry), exception);
                if (retry >= this.maxRetryTimes) {
                    throw new RuntimeException("Execution of JDBC statement failed.", exception);
                }
                if (!this.connection.isValid(1000)) {
                    this.statement.close();
                    this.connection.close();
                    this.establishConnectionAndStatement();
                }
                try {
                    Thread.sleep(1000 * retry);
                    continue;
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private void establishConnectionAndStatement() throws SQLException, ClassNotFoundException {
        DriverManager.getDrivers();
        Class.forName(this.drivername);
        this.connection = DriverManager.getConnection(this.dbURL, this.username, this.password);
        this.statement = this.connection.prepareStatement(this.scanTemplate);
    }

    public static DataType getRowDataType(String[] fieldNames, DataType[] fieldTypes) {
        DataTypes.Field[] fields = new DataTypes.Field[fieldNames.length];
        for (int j = 0; j < fieldNames.length; ++j) {
            fields[j] = DataTypes.FIELD((String)fieldNames[j], (DataType)fieldTypes[j]);
        }
        return (DataType)DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(RowData.class);
    }
}

