/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc;

import com.alibaba.ververica.connectors.common.dim.DimOptions;
import java.time.Duration;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.util.Preconditions;

public class VervericaJdbcValidator {
    public static final ConfigOption<String> URL = ConfigOptions.key((String)"url").stringType().noDefaultValue().withDescription("The jdbc database url.");
    public static final ConfigOption<String> TABLENAME = ConfigOptions.key((String)"tableName").stringType().noDefaultValue().withDescription("The jdbc table name.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"userName").stringType().noDefaultValue().withDescription("The jdbc user name.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("The jdbc password.");
    public static final ConfigOption<Integer> MAX_RETRIES = ConfigOptions.key((String)"maxRetryTimes").intType().defaultValue((Object)3).withDescription("The max retry times if write or lookup database failed");
    public static final ConfigOption<String> LOOKUP_CACHE_STRATEGY = ConfigOptions.key((String)"cache").stringType().defaultValue((Object)"ALL").withDescription("Cache type for the lookup table. Valid values are 'ALL', 'LRU' and 'NONE'.");
    public static final ConfigOption<Long> LOOKUP_CACHE_MAX_ROWS = ConfigOptions.key((String)"cacheSize").longType().defaultValue(DimOptions.MAX_CACHE_SIZE.defaultValue()).withDescription("When use 'LRU' cache, the max number of rows of lookup cache, over this value, the oldest rows will be eliminated.");
    public static final ConfigOption<Long> LOOKUP_CACHE_TTL = ConfigOptions.key((String)"cacheTTLMs").longType().defaultValue(DimOptions.CACHE_TTL.defaultValue()).withDescription("Time to live for data in cache.");
    public static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"batchSize").intType().defaultValue((Object)100).withDescription("The flush max size (includes all append, upsert and delete records), over this number of records, will flush data. The default value is 100.");
    public static final ConfigOption<Long> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"flushIntervalMs").longType().defaultValue((Object)1000L).withDescription("The flush interval mills, over this time, asynchronous threads will flush data. The default value is 1000.");
    public static final ConfigOption<Duration> MAX_RETRY_TIMEOUT = ConfigOptions.key((String)"maxRetryTimeout").durationType().defaultValue((Object)Duration.ofSeconds(60L)).withDescription("Maximum timeout between retries.");

    public static void validateConfigOptions(ReadableConfig config, JdbcDialect dialect) {
        config.getOptional(URL).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find required option: %s", URL.key())));
        config.getOptional(TABLENAME).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find required option: %s", TABLENAME.key())));
        if (dialect instanceof URLValidator) {
            URLValidator urlValidator = (URLValidator)((Object)dialect);
            String jdbcUrl = (String)config.get(URL);
            Preconditions.checkState((boolean)urlValidator.canHandle(jdbcUrl), (Object)String.format("Jdbc dialect %s cannot handle such jdbc url: %s", dialect.dialectName(), jdbcUrl));
        }
        if (config.getOptional(USERNAME).isPresent()) {
            Preconditions.checkState((boolean)config.getOptional(PASSWORD).isPresent(), (Object)"Database username must be provided when database password is provided");
        }
        Preconditions.checkState(((Integer)config.get(MAX_RETRIES) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", MAX_RETRIES.key(), config.get(MAX_RETRIES)));
        if (config.getOptional(LOOKUP_CACHE_STRATEGY).isPresent()) {
            String cacheStrategy = (String)config.get(LOOKUP_CACHE_STRATEGY);
            if (!(cacheStrategy.equalsIgnoreCase("ALL") || cacheStrategy.equalsIgnoreCase("LRU") || cacheStrategy.equalsIgnoreCase("None"))) {
                throw new IllegalArgumentException(String.format("Jdbc don't support cache strategy: %s", cacheStrategy));
            }
            if (cacheStrategy.equalsIgnoreCase("LRU")) {
                Preconditions.checkState(((Long)config.get(LOOKUP_CACHE_MAX_ROWS) > 0L ? 1 : 0) != 0, (Object)String.format("When using 'LRU' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_MAX_ROWS.key(), config.get(LOOKUP_CACHE_MAX_ROWS)));
                Preconditions.checkState(((Long)config.get(LOOKUP_CACHE_TTL) > 0L ? 1 : 0) != 0, (Object)String.format("When using 'LRU' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_TTL.key(), config.get(LOOKUP_CACHE_TTL)));
            } else if (cacheStrategy.equalsIgnoreCase("ALL")) {
                Preconditions.checkState(((Long)config.get(LOOKUP_CACHE_TTL) > 0L ? 1 : 0) != 0, (Object)String.format("When using 'ALL' Cache, the value of '%s' option should be positive, but is %s.", LOOKUP_CACHE_TTL.key(), config.get(LOOKUP_CACHE_TTL)));
            }
        }
        Preconditions.checkState(((Integer)config.get(SINK_BUFFER_FLUSH_MAX_ROWS) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_BUFFER_FLUSH_MAX_ROWS.key(), config.get(SINK_BUFFER_FLUSH_MAX_ROWS)));
        Preconditions.checkState(((Long)config.get(SINK_BUFFER_FLUSH_INTERVAL) >= 0L ? 1 : 0) != 0, (Object)String.format("The value of '%s' option shouldn't be negative, but is %s.", SINK_BUFFER_FLUSH_INTERVAL.key(), config.get(SINK_BUFFER_FLUSH_INTERVAL)));
    }

    public static interface URLValidator {
        public boolean canHandle(String var1);
    }
}

