/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc;

import com.alibaba.ververica.connectors.jdbc.dim.VervericaJdbcAllCacheLookupFunction;
import com.alibaba.ververica.connectors.jdbc.dim.VervericaJdbcLookupOptions;
import com.alibaba.ververica.connectors.jdbc.dim.VervericaJdbcRowDataLookupFunction;
import com.alibaba.ververica.connectors.jdbc.options.JdbcLookupOptions;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class VervericaJdbcDynamicTableSource
implements LookupTableSource {
    private final InternalJdbcConnectionOptions options;
    private final VervericaJdbcLookupOptions lookupOptions;
    private final TableSchema physicalSchema;

    public VervericaJdbcDynamicTableSource(InternalJdbcConnectionOptions options, VervericaJdbcLookupOptions lookupOptions, TableSchema physicalSchema) {
        this.options = options;
        this.lookupOptions = lookupOptions;
        this.physicalSchema = physicalSchema;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"JDBC only support non-nested look up keys");
            keyNames[i] = this.physicalSchema.getFieldNames()[innerKeyArr[0]];
        }
        RowType rowType = (RowType)this.physicalSchema.toRowDataType().getLogicalType();
        if (this.lookupOptions.isCacheALL()) {
            Preconditions.checkState((this.lookupOptions.getCacheExpireMs() > 0L ? 1 : 0) != 0);
            return TableFunctionProvider.of((TableFunction)new VervericaJdbcAllCacheLookupFunction(this.options, this.lookupOptions, this.physicalSchema.getFieldNames(), this.physicalSchema.getFieldDataTypes(), keyNames, rowType));
        }
        JdbcLookupOptions.Builder builder = JdbcLookupOptions.builder();
        if (this.lookupOptions.isCacheLRU()) {
            Preconditions.checkState((this.lookupOptions.getCacheExpireMs() > 0L ? 1 : 0) != 0);
            Preconditions.checkState((this.lookupOptions.getCacheMaxSize() > 0L ? 1 : 0) != 0);
            builder.setCacheExpireMs(this.lookupOptions.getCacheExpireMs()).setMaxRetryTimes(this.lookupOptions.getMaxRetryTimes()).setCacheMaxSize(this.lookupOptions.getCacheMaxSize());
        } else {
            builder.setCacheMaxSize(-1L).setCacheExpireMs(-1L);
        }
        return TableFunctionProvider.of((TableFunction)new VervericaJdbcRowDataLookupFunction(this.options, builder.build(), this.physicalSchema.getFieldNames(), this.physicalSchema.getFieldDataTypes(), keyNames, rowType));
    }

    public DynamicTableSource copy() {
        return new VervericaJdbcDynamicTableSource(this.options, this.lookupOptions, this.physicalSchema);
    }

    public String asSummaryString() {
        return "JDBC:" + this.options.getDialect().dialectName();
    }
}

