/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import com.alibaba.ververica.connectors.common.util.ByteString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Set;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;

public class StringSerializer {
    public static DataFormatConverters.TimestampConverter timestampConverter = new DataFormatConverters.TimestampConverter(3);
    private static Base64.Decoder decoder = Base64.getDecoder();

    public static Object deserialize(String value, ByteSerializer.ValueType type, DataType dataType, Set<String> nullValues) {
        return StringSerializer.deserialize(value, type, dataType, nullValues, false);
    }

    public static Object deserialize(String value, ByteSerializer.ValueType type, DataType dataType, Set<String> nullValues, Boolean isRGData) {
        if (null != nullValues && nullValues.contains(value)) {
            return null;
        }
        switch (type) {
            case V_ByteArray: {
                if (isRGData.booleanValue()) {
                    byte[] bytes = null;
                    try {
                        bytes = decoder.decode(value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bytes;
                }
                return value.getBytes();
            }
            case V_String: {
                return BinaryStringData.fromString((String)value);
            }
            case V_Byte: {
                return null == value ? null : Byte.valueOf(Byte.parseByte(value));
            }
            case V_Short: {
                return null == value ? null : Short.valueOf(Short.parseShort(value));
            }
            case V_Integer: {
                return null == value ? null : Integer.valueOf(Integer.parseInt(value));
            }
            case V_Long: {
                return null == value ? null : Long.valueOf(Long.parseLong(value));
            }
            case V_Float: {
                return null == value ? null : Float.valueOf(Float.parseFloat(value));
            }
            case V_Double: {
                return null == value ? null : Double.valueOf(Double.parseDouble(value));
            }
            case V_Boolean: {
                return null == value ? null : StringSerializer.parseBoolean(value);
            }
            case V_Timestamp: {
                if (isRGData.booleanValue()) {
                    return null == value ? null : Long.valueOf(Long.parseLong(value));
                }
                if (null == value) {
                    return null;
                }
                try {
                    return timestampConverter.toInternal((Object)new Timestamp(Long.parseLong(value)));
                }
                catch (NumberFormatException e) {
                    return timestampConverter.toInternal((Object)Timestamp.valueOf(value));
                }
            }
            case V_Date: {
                if (isRGData.booleanValue()) {
                    return null == value ? null : Long.valueOf(Long.parseLong(value));
                }
                return null == value ? null : DataFormatConverters.DateConverter.INSTANCE.toInternal((Object)Date.valueOf(value));
            }
            case V_Time: {
                if (isRGData.booleanValue()) {
                    return null == value ? null : Long.valueOf(Long.parseLong(value));
                }
                return null == value ? null : DataFormatConverters.TimeConverter.INSTANCE.toInternal((Object)new Time(Long.parseLong(value)));
            }
            case V_BigDecimal: {
                DecimalType decimalType = (DecimalType)dataType.getLogicalType();
                return value == null ? null : DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(value), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case V_BigInteger: {
                return null == value ? null : new BigInteger(value);
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.dataTypeError(String.valueOf((Object)type)));
    }

    public static Object deserialize(String value, ByteSerializer.ValueType type, DataType dataType, Boolean isRGData) {
        return StringSerializer.deserialize(value, type, dataType, null, isRGData);
    }

    public static Object deserialize(ByteString value, ByteSerializer.ValueType type, DataType dataType, Boolean isRGData, Object reuse) {
        if (value == null) {
            return null;
        }
        switch (type) {
            case V_ByteArray: {
                if (isRGData.booleanValue()) {
                    byte[] bytes = null;
                    try {
                        bytes = decoder.decode(value.toStringUtf8());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bytes;
                }
                return value.toByteArray();
            }
            case V_String: {
                BinaryStringData str = (BinaryStringData)reuse;
                int size = value.size();
                MemorySegment[] segments = str.getSegments() == null || str.getSegments()[0].size() < size ? new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[size])} : str.getSegments();
                value.copyTo(segments[0].getHeapMemory(), 0);
                return BinaryStringData.fromAddress((MemorySegment[])segments, (int)0, (int)size);
            }
            case V_Byte: {
                return Byte.parseByte(value.toStringUtf8());
            }
            case V_Short: {
                return Short.parseShort(value.toStringUtf8());
            }
            case V_Integer: {
                return Integer.parseInt(value.toStringUtf8());
            }
            case V_Long: {
                return Long.parseLong(value.toStringUtf8());
            }
            case V_Float: {
                return Float.valueOf(Float.parseFloat(value.toStringUtf8()));
            }
            case V_Double: {
                return Double.parseDouble(value.toStringUtf8());
            }
            case V_Boolean: {
                return StringSerializer.parseBoolean(value.toStringUtf8());
            }
            case V_Timestamp: {
                if (isRGData.booleanValue()) {
                    return Long.parseLong(value.toStringUtf8());
                }
                try {
                    return timestampConverter.toInternal((Object)new Timestamp(Long.parseLong(value.toStringUtf8())));
                }
                catch (NumberFormatException e) {
                    return timestampConverter.toInternal((Object)Timestamp.valueOf(value.toStringUtf8()));
                }
            }
            case V_Date: {
                if (isRGData.booleanValue()) {
                    return Long.parseLong(value.toStringUtf8());
                }
                return DataFormatConverters.DateConverter.INSTANCE.toInternal((Object)Date.valueOf(value.toStringUtf8()));
            }
            case V_Time: {
                if (isRGData.booleanValue()) {
                    return Long.parseLong(value.toStringUtf8());
                }
                return DataFormatConverters.TimeConverter.INSTANCE.toInternal((Object)new Time(Long.parseLong(value.toStringUtf8())));
            }
            case V_BigDecimal: {
                DecimalType decimalType = (DecimalType)dataType.getLogicalType();
                return DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(value.toStringUtf8()), (int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case V_BigInteger: {
                return new BigInteger(value.toStringUtf8());
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.dataTypeError(String.valueOf((Object)type)));
    }

    public static Boolean parseBoolean(String s) {
        if (s != null) {
            if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
                return Boolean.valueOf(s);
            }
            if (s.equals("1")) {
                return Boolean.TRUE;
            }
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.booleanParseError(s));
    }
}

