/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

public class MemoryPool
implements MemorySegmentPool {
    private final ArrayList<MemorySegment> cachePages = new ArrayList();
    private final int pageSize;

    public MemoryPool() {
        this(32768);
    }

    public MemoryPool(int pageSize) {
        this.pageSize = pageSize;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public void returnAll(List<MemorySegment> memory) {
        this.cachePages.addAll(memory);
    }

    public MemorySegment nextSegment() {
        return this.cachePages.isEmpty() ? MemorySegmentFactory.allocateUnpooledSegment((int)this.pageSize()) : this.cachePages.remove(this.cachePages.size() - 1);
    }

    public int freePages() {
        return Integer.MAX_VALUE;
    }
}

