/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.factories.Factory;

public class FactoryOptionUtil {
    public static Map<String, String> normalizeOptionCaseAsFactory(Factory factory, Map<String, String> options) {
        HashMap<String, String> normalizedOptions = new HashMap<String, String>();
        Map<String, String> requiredOptionKeysLowerCaseToOriginal = factory.requiredOptions().stream().collect(Collectors.toMap(option -> option.key().toLowerCase(), ConfigOption::key));
        Map<String, String> optionalOptionKeysLowerCaseToOriginal = factory.optionalOptions().stream().collect(Collectors.toMap(option -> option.key().toLowerCase(), ConfigOption::key));
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String catalogOptionKey = entry.getKey();
            String catalogOptionValue = entry.getValue();
            normalizedOptions.put(requiredOptionKeysLowerCaseToOriginal.containsKey(catalogOptionKey.toLowerCase()) ? requiredOptionKeysLowerCaseToOriginal.get(catalogOptionKey.toLowerCase()) : optionalOptionKeysLowerCaseToOriginal.getOrDefault(catalogOptionKey.toLowerCase(), catalogOptionKey), catalogOptionValue);
        }
        return normalizedOptions;
    }
}

