/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.util.ByteUtils;
import com.alibaba.ververica.connectors.common.util.StringSerializer;
import com.alibaba.ververica.connectors.common.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.util.DataFormatConverters;

@Internal
public class ByteSerializer {
    public static final byte[] EMPTY_STRING_BYTES = "".getBytes();
    public static final byte[] EMPTY_BYTE_BYTES = new byte[]{0};
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static Object deserialize(byte[] value, ValueType type) {
        return ByteSerializer.deserialize(value, type, DEFAULT_CHARSET);
    }

    public static Object deserialize(byte[] value, ValueType type, Charset charset) {
        switch (type) {
            case V_String: {
                return null == value ? "" : new String(value, charset);
            }
            case V_Timestamp: {
                return new Timestamp(ByteUtils.toLong(value));
            }
            case V_Date: {
                return new Date(ByteUtils.toLong(value));
            }
            case V_Time: {
                return new Time(ByteUtils.toLong(value));
            }
            case V_BigDecimal: {
                return ByteUtils.toBigDecimal(value);
            }
        }
        return ByteSerializer.commonDeserialize(value, type);
    }

    public static Object deserializeToInnerObject(byte[] value, ValueType type) {
        return ByteSerializer.deserializeToInnerObject(value, type, DEFAULT_CHARSET);
    }

    public static Object deserializeToInnerObject(byte[] value, ValueType type, Charset charset) {
        switch (type) {
            case V_ByteArray: {
                return value;
            }
            case V_String: {
                return null == value ? "" : StringUtils.fromBytes(value, charset);
            }
            case V_Timestamp: {
                return StringSerializer.timestampConverter.toInternal((Object)new Timestamp(ByteUtils.toLong(value)));
            }
            case V_Date: {
                return DataFormatConverters.DateConverter.INSTANCE.toInternal((Object)new Date(ByteUtils.toLong(value)));
            }
            case V_Time: {
                return DataFormatConverters.TimeConverter.INSTANCE.toInternal((Object)new Time(ByteUtils.toLong(value)));
            }
            case V_BigDecimal: {
                return ByteUtils.toBigDecimal(value);
            }
        }
        return ByteSerializer.commonDeserialize(value, type);
    }

    private static Object commonDeserialize(byte[] value, ValueType type) {
        switch (type) {
            case V_ByteArray: {
                return value;
            }
            case V_Byte: {
                return null == value ? (byte)0 : value[0];
            }
            case V_Short: {
                return ByteUtils.toShort(value);
            }
            case V_Integer: {
                return ByteUtils.toInt(value);
            }
            case V_Long: {
                return ByteUtils.toLong(value);
            }
            case V_Float: {
                return Float.valueOf(ByteUtils.toFloat(value));
            }
            case V_Double: {
                return ByteUtils.toDouble(value);
            }
            case V_Boolean: {
                return ByteUtils.toBoolean(value);
            }
            case V_BigInteger: {
                return new BigInteger(value);
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.dataTypeError(type.toString()));
    }

    public static byte[] toBytes(Object value, ValueType type) {
        return ByteSerializer.toBytes(value, type, DEFAULT_CHARSET);
    }

    public static byte[] toBytes(Object value, ValueType type, Charset charset) {
        switch (type) {
            case V_ByteArray: {
                return (byte[])value;
            }
            case V_String: {
                return null == value ? EMPTY_STRING_BYTES : ((String)value).getBytes(charset);
            }
            case V_Byte: {
                byte[] byArray;
                if (null == value) {
                    byArray = EMPTY_BYTE_BYTES;
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = (Byte)value;
                }
                return byArray;
            }
            case V_Short: {
                return ByteUtils.toBytes((Short)value);
            }
            case V_Integer: {
                return ByteUtils.toBytes((Integer)value);
            }
            case V_Long: {
                return ByteUtils.toBytes((Long)value);
            }
            case V_Float: {
                return ByteUtils.toBytes(((Float)value).floatValue());
            }
            case V_Double: {
                return ByteUtils.toBytes((Double)value);
            }
            case V_Boolean: {
                return ByteUtils.toBytes((Boolean)value);
            }
            case V_Timestamp: {
                return ByteUtils.toBytes(((Timestamp)value).getTime());
            }
            case V_Date: {
                return ByteUtils.toBytes(((Date)value).getTime());
            }
            case V_Time: {
                return ByteUtils.toBytes(((Time)value).getTime());
            }
            case V_BigDecimal: {
                return ByteUtils.toBytes((BigDecimal)value);
            }
            case V_BigInteger: {
                return ((BigInteger)value).toByteArray();
            }
        }
        throw new IllegalArgumentException(ConnectorErrors.INST.dataTypeError(type.toString()));
    }

    public static ValueType getTypeIndex(Class<?> clazz) {
        if (byte[].class.equals(clazz)) {
            return ValueType.V_ByteArray;
        }
        if (String.class.equals(clazz)) {
            return ValueType.V_String;
        }
        if (Byte.class.equals(clazz)) {
            return ValueType.V_Byte;
        }
        if (Short.class.equals(clazz)) {
            return ValueType.V_Short;
        }
        if (Integer.class.equals(clazz)) {
            return ValueType.V_Integer;
        }
        if (Long.class.equals(clazz)) {
            return ValueType.V_Long;
        }
        if (Float.class.equals(clazz)) {
            return ValueType.V_Float;
        }
        if (Double.class.equals(clazz)) {
            return ValueType.V_Double;
        }
        if (Boolean.class.equals(clazz)) {
            return ValueType.V_Boolean;
        }
        if (Timestamp.class.equals(clazz)) {
            return ValueType.V_Timestamp;
        }
        if (Date.class.equals(clazz)) {
            return ValueType.V_Date;
        }
        if (Time.class.equals(clazz)) {
            return ValueType.V_Time;
        }
        if (BigDecimal.class.equals(clazz)) {
            return ValueType.V_BigDecimal;
        }
        if (BigInteger.class.equals(clazz)) {
            return ValueType.V_BigInteger;
        }
        if (LocalDateTime.class.equals(clazz)) {
            return ValueType.V_LocalDateTime;
        }
        if (LocalDate.class.equals(clazz)) {
            return ValueType.V_LocalDate;
        }
        if (Duration.class.equals(clazz)) {
            return ValueType.V_Duration;
        }
        if (LocalTime.class.equals(clazz)) {
            return ValueType.V_LocalTime;
        }
        if (Period.class.equals(clazz)) {
            return ValueType.V_Period;
        }
        if (OffsetDateTime.class.equals(clazz)) {
            return ValueType.V_OffsetDateTime;
        }
        return ValueType.Unsupported;
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return ByteSerializer.getTypeIndex(clazz) != ValueType.Unsupported;
    }

    public static enum ValueType {
        V_ByteArray,
        V_String,
        V_Byte,
        V_Short,
        V_Integer,
        V_Long,
        V_Float,
        V_Double,
        V_Boolean,
        V_Timestamp,
        V_Date,
        V_Time,
        V_BigDecimal,
        V_BigInteger,
        V_LocalDateTime,
        V_LocalDate,
        V_Duration,
        V_LocalTime,
        V_Period,
        V_OffsetDateTime,
        Unsupported;

    }
}

