/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver.parse;

import com.alibaba.ververica.connectors.common.source.message.BytesMessage;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.source.resolver.parse.AbstractHighSpeedParser;
import com.alibaba.ververica.connectors.common.source.resolver.parse.BinaryBufferedTextRowData;
import com.alibaba.ververica.connectors.common.source.resolver.parse.BufferedTextRowData;
import com.alibaba.ververica.connectors.common.source.resolver.parse.NativeParseUtils;
import com.alibaba.ververica.connectors.common.source.resolver.parse.SIMDParserSharedResource;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Meter;
import org.apache.flink.runtime.natives.memory.NativeMemoryAllocator;
import org.apache.flink.runtime.natives.memory.NativeMemoryPool;
import org.apache.flink.streaming.natives.NativeBufferReader;
import org.apache.flink.streaming.natives.NativeBufferWriter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.natives.NativeEngineLoading;

public class BufferedTextRowSIMDParser
extends AbstractHighSpeedParser {
    private final int columnSize;
    private final int[] earlyParsingFields;
    private final byte fieldDelim;
    private final byte lineDelim;
    private final BufferedTextRowData reuseRow;
    private final Meter parserTpsMetrics;
    private final NativeMemoryPool nativeMemPool;
    private final NativeMemoryAllocator nativeMemAlloc;
    private final NativeBufferWriter writer;

    public BufferedTextRowSIMDParser(ByteSerializer.ValueType[] fieldTypes, DataType[] fieldDataTypes, String fieldDelimiter, String lineDelimiter, @Nullable Set<String> nullValues, boolean columnErrorDebug, Meter parserTpsMetrics, long memPoolSize) {
        super(fieldTypes, fieldDataTypes, fieldDelimiter, false, (List<String>)(nullValues == null ? Collections.emptyList() : new ArrayList<String>(nullValues)), columnErrorDebug);
        NativeEngineLoading.ensureNativeLoaded();
        this.nativeMemPool = SIMDParserSharedResource.getInstance(memPoolSize).getMemPool();
        this.nativeMemAlloc = NativeMemoryAllocator.getSharedInstance((NativeMemoryPool)this.nativeMemPool);
        this.columnSize = fieldTypes.length;
        this.earlyParsingFields = BufferedTextRowSIMDParser.getEarlyParsingFields(fieldTypes);
        byte[] fieldDelimBytes = fieldDelimiter.getBytes();
        Preconditions.checkArgument((fieldDelimBytes.length == 1 ? 1 : 0) != 0, (Object)"Field delimiter must have only 1 byte");
        this.fieldDelim = fieldDelimiter.getBytes()[0];
        byte[] lineDelimBytes = lineDelimiter.getBytes();
        Preconditions.checkArgument((lineDelimBytes.length == 1 ? 1 : 0) != 0, (Object)"Line delimiter must have only 1 byte");
        this.lineDelim = lineDelimiter.getBytes()[0];
        this.reuseRow = new BinaryBufferedTextRowData(fieldTypes);
        this.parserTpsMetrics = parserTpsMetrics;
        this.writer = new NativeBufferWriter(65536, this.nativeMemAlloc);
    }

    private static int[] getEarlyParsingFields(ByteSerializer.ValueType[] fieldTypes) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        block3: for (int i = 0; i < fieldTypes.length; ++i) {
            switch (fieldTypes[i]) {
                case V_ByteArray: 
                case V_String: {
                    continue block3;
                }
                default: {
                    result.add(i);
                }
            }
        }
        return result.stream().mapToInt(x -> x).toArray();
    }

    @Override
    public void parseBytesMessageByBinary(Collector<RowData> collector, RawMessage<?> msg) {
        byte[] readBuffer = ((BytesMessage)msg).getData();
        if (readBuffer.length == 0) {
            return;
        }
        this.reuseRow.replaceBuffer(readBuffer);
        this.writer.write(readBuffer);
        long addr = NativeParseUtils.findDelimiters((long)this.writer.getAddress(), (int)readBuffer.length, (byte)this.fieldDelim, (byte)this.lineDelim, (long)this.nativeMemAlloc.getNativeAllocator());
        NativeBufferReader reader = new NativeBufferReader(addr);
        int byteLength = reader.readInt() - 4;
        int fieldIndex = -1;
        int field = 0;
        int lineStart = 0;
        for (int i = 0; i < byteLength; i += 5) {
            int start = fieldIndex + 1;
            if (reader.readBoolean()) {
                fieldIndex = reader.readInt();
                this.setField(readBuffer, start, fieldIndex - start, field);
                if (++field < this.columnSize) {
                    this.logFieldMiss(readBuffer, lineStart, fieldIndex - lineStart);
                } else if (this.earlyParse(lineStart, fieldIndex - lineStart)) {
                    collector.collect((Object)this.reuseRow);
                    if (this.parserTpsMetrics != null) {
                        this.parserTpsMetrics.markEvent();
                    }
                }
                field = 0;
                lineStart = fieldIndex + 1;
                continue;
            }
            fieldIndex = reader.readInt();
            this.setField(readBuffer, start, fieldIndex - start, field);
            ++field;
        }
        if (readBuffer[readBuffer.length - 1] != this.lineDelim) {
            int start = fieldIndex + 1;
            this.setField(readBuffer, start, readBuffer.length - start, field);
            if (++field < this.columnSize) {
                this.logFieldMiss(readBuffer, lineStart, readBuffer.length - lineStart);
            } else if (this.earlyParse(lineStart, readBuffer.length - lineStart)) {
                collector.collect((Object)this.reuseRow);
                if (this.parserTpsMetrics != null) {
                    this.parserTpsMetrics.markEvent();
                }
            }
        }
        this.nativeMemAlloc.deallocate(addr);
        this.writer.clear();
    }

    private void setField(byte[] buffer, int start, int length, int idx) {
        if (idx < this.columnSize) {
            if (this.isNullField(buffer, start, length)) {
                this.reuseRow.setNullAt(idx);
            } else {
                this.reuseRow.setNotNullAt(idx);
            }
            this.reuseRow.setPointersAt(idx, start, length);
        }
    }

    private boolean earlyParse(int lineStart, int lineLen) {
        for (int idx : this.earlyParsingFields) {
            if (this.reuseRow.isNullAt(idx)) continue;
            int start = this.reuseRow.getStart(idx);
            int len = this.reuseRow.getLength(idx);
            try {
                this.reuseRow.setField(idx, this.deserializeBinary(this.reuseRow.getBuffer(), start, start + len, idx, null, null));
            }
            catch (Exception e) {
                this.logParseException(this.reuseRow.getBuffer(), lineStart, lineLen, idx, e);
                return false;
            }
        }
        return true;
    }
}

