/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver;

import com.alibaba.ververica.connectors.common.source.resolver.RecordResolver;
import com.alibaba.ververica.connectors.common.table.VervericaTableOptions;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.util.StringUtils;

public class RecordResolverUtil {
    public static RecordResolver getRecordResolver(TableSchema tableSchema, Map<String, String> properties, ClassLoader classLoader) {
        RecordResolver converter;
        String collectorClass = properties.get(VervericaTableOptions.SOURCE_COLLECTOR_CLASS.key());
        if (!StringUtils.isNullOrWhitespaceOnly((String)collectorClass)) {
            try {
                converter = (RecordResolver)Class.forName(collectorClass, true, classLoader).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("new instance of SourceCollector fail", e);
            }
        } else {
            return null;
        }
        return converter;
    }
}

