/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.reader;

import com.alibaba.ververica.connectors.common.MetricUtils;
import com.alibaba.ververica.connectors.common.metrics.Latency;
import com.alibaba.ververica.connectors.common.source.WatermarkProvider;
import com.alibaba.ververica.connectors.common.source.reader.Interruptible;
import com.alibaba.ververica.connectors.common.source.reader.RecordReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelReader<OUT, CURSOR extends Serializable>
implements WatermarkProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelReader.class);
    private static final String SPLIT_PIPE_LEN_CONFIG = "yarn.app.blink.source.buffer-len";
    private static final String IDLE_INTERVAL_CONFIG = "yarn.app.blink.source.idle-interval";
    private static final long STOP_WAITING = 5L;
    private long idleInterval = 1L;
    private int splitPipeLen = 1024;
    private final ExecutorService readerPool = Executors.newCachedThreadPool();
    private final BlockingQueue<ReaderRunner<OUT, CURSOR>> readerRunners = new LinkedBlockingQueue<ReaderRunner<OUT, CURSOR>>();
    private WatermarkEmitter<OUT> watermarkEmitter = null;
    private volatile boolean stop = false;
    private volatile boolean exitAfterReadFinished = false;
    private final long watermarkInterval;
    private final RuntimeContext context;
    private Configuration config;
    private final Meter tpsMetric;
    private final boolean tracingMetricEnabled;
    private Latency partitionLatency;
    private Latency processLatency;
    private Gauge<Integer> partitionCount;
    private final long sampleInterval;
    private long inputCount;
    private final Clock clock;
    private final AtomicBoolean partitionChangedAfterIdle;
    private final Map<Integer, Long> splitIdToEmitLag = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Long> splitIdToSamplingCount = new HashMap<Integer, Long>();
    public static final Long INVALID = -1L;
    private transient Map<InputSplit, CURSOR> exitedReadRunnerSplitCursor = new HashMap<InputSplit, CURSOR>();

    public ParallelReader(RuntimeContext context, Configuration config, long watermarkInterval, boolean tracingMetricEnabled, long sampleInterval, Clock clock, AtomicBoolean partitionChangedAfterIdle) {
        this.context = context;
        this.config = config;
        this.watermarkInterval = watermarkInterval;
        this.clock = clock;
        this.partitionChangedAfterIdle = partitionChangedAfterIdle;
        this.splitPipeLen = config.getInteger(SPLIT_PIPE_LEN_CONFIG, 10);
        this.idleInterval = config.getInteger(IDLE_INTERVAL_CONFIG, 10);
        LOG.info("idleInterval:" + this.idleInterval);
        LOG.info("splitPipeLen:" + this.splitPipeLen);
        context.getMetricGroup().gauge("currentEmitEventTimeLag", () -> {
            long maxEmitLag = INVALID;
            for (Long emitLag : this.splitIdToEmitLag.values()) {
                if (emitLag <= maxEmitLag) continue;
                maxEmitLag = emitLag;
            }
            return maxEmitLag;
        });
        context.getMetricGroup().gauge("currentFetchEventTimeLag", (Gauge)new DelayGauge(this.readerRunners, DelayKind.FETCHED_DELAY));
        context.getMetricGroup().gauge("sourceIdleTime", (Gauge)new DelayGauge(this.readerRunners, DelayKind.NO_DATA_DELAY));
        context.getMetricGroup().gauge("watermarkLag", (Gauge)new DelayGauge(this.readerRunners, DelayKind.WATERMARK_DELAY));
        this.tpsMetric = MetricUtils.registerNumRecordBatchesInRate(context);
        this.tracingMetricEnabled = tracingMetricEnabled;
        this.sampleInterval = sampleInterval;
        if (this.tracingMetricEnabled) {
            this.partitionLatency = new Latency("sourcePartitionLatency", (MetricGroup)context.getMetricGroup());
            this.processLatency = new Latency("sourceProcessLatency", (MetricGroup)context.getMetricGroup());
            this.partitionCount = context.getMetricGroup().gauge("sourcePartitionCount", (Gauge)new Gauge<Integer>(){

                public Integer getValue() {
                    int count = 0;
                    for (ReaderRunner runner : ParallelReader.this.readerRunners) {
                        if (runner.finished) continue;
                        ++count;
                    }
                    return count;
                }
            });
        }
    }

    public ParallelReader<OUT, CURSOR> setExitAfterReadFinished(boolean exitAfterReadFinished) {
        this.exitAfterReadFinished = exitAfterReadFinished;
        return this;
    }

    public void addRecordReader(RecordReader<OUT, CURSOR> recordReader, InputSplit split, CURSOR cursor) throws IOException {
        ReaderRunner<OUT, CURSOR> readerRunner = new ReaderRunner<OUT, CURSOR>(recordReader, split, cursor, this.context, this.splitPipeLen, this.idleInterval, this.tracingMetricEnabled, this.sampleInterval);
        this.readerRunners.add(readerRunner);
    }

    public void run(SourceFunction.SourceContext<OUT> ctx) throws Exception {
        try {
            this.submitReaders();
            this.runWatermarkEmitter(ctx);
            this.runImpl(ctx);
        }
        catch (InterruptedException e) {
            LOG.error("ParallelReader was interrupted: ", e);
        }
        catch (Throwable e) {
            LOG.error("ParallelReader caught exception: ", e);
            throw new RuntimeException(e);
        }
        finally {
            this.close();
        }
    }

    private void runWatermarkEmitter(SourceFunction.SourceContext<OUT> ctx) {
        if (this.watermarkInterval > 0L) {
            this.watermarkEmitter = new WatermarkEmitter<OUT>(this, this.watermarkInterval, ctx);
            this.readerPool.submit(this.watermarkEmitter);
        }
    }

    public void stop() {
        this.stop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean released = false;
        try {
            for (ReaderRunner readerRunner : this.readerRunners) {
                readerRunner.stop();
            }
            if (this.watermarkEmitter != null) {
                this.watermarkEmitter.stop();
            }
            try {
                Thread.sleep(100L * this.idleInterval);
            }
            catch (InterruptedException e) {
                LOG.warn("Waiting for reader stopping is interrupted.", e);
            }
            this.readerPool.shutdownNow();
            released = this.readerPool.awaitTermination(5L, TimeUnit.SECONDS);
            if (!released) {
                for (ReaderRunner readerRunner : this.readerRunners) {
                    if (readerRunner.isStopped()) continue;
                    LOG.info("Can not stop reader for split {}, it is stuck in method: \n {}.", (Object)readerRunner.getSplit(), (Object)readerRunner.getStackTrace());
                }
            }
        }
        catch (Throwable e) {
            LOG.warn(e.toString());
        }
        finally {
            if (!released) {
                LOG.error("Shut down reader pool failed, exit process!");
                System.exit(1);
            }
            LOG.info("Stopped all split reader.");
        }
    }

    protected void runImpl(SourceFunction.SourceContext<OUT> ctx) throws Exception {
        while (!this.stop && !this.readerRunners.isEmpty()) {
            Iterator it = this.readerRunners.iterator();
            boolean idle = true;
            while (it.hasNext()) {
                ReaderRunner readerRunner = (ReaderRunner)it.next();
                if (readerRunner.isStopped() && readerRunner.getCause() != null) {
                    LOG.error(String.format("SplitReader for split[%d][%s] failed, cause: %s", readerRunner.getSplit().getSplitNumber(), readerRunner.getSplit().toString(), readerRunner.getCause()));
                    throw new RuntimeException(readerRunner.getCause());
                }
                if (readerRunner.isExhausted()) {
                    LOG.info(String.format("SplitReader for split[%d][%s] finished", readerRunner.getSplit().getSplitNumber(), readerRunner.getSplit().toString()));
                    this.exitedReadRunnerSplitCursor.put(readerRunner.getSplit(), readerRunner.getProgress());
                    this.splitIdToEmitLag.remove(readerRunner.getSplit().getSplitNumber());
                    this.splitIdToSamplingCount.remove(readerRunner.getSplit().getSplitNumber());
                    it.remove();
                    continue;
                }
                if (!readerRunner.hasRecord()) continue;
                idle = false;
                ++this.inputCount;
                if (this.tracingMetricEnabled && this.inputCount % this.sampleInterval == 0L) {
                    long now = System.nanoTime();
                    this.processRecord(ctx, readerRunner);
                    this.processLatency.update(System.nanoTime() - now);
                    continue;
                }
                this.processRecord(ctx, readerRunner);
            }
            if (!idle) continue;
            Thread.sleep(this.idleInterval);
        }
        ctx.markAsTemporarilyIdle();
        LOG.info(String.format("This subTask [%d]/[%d] has finished, idle...", this.context.getIndexOfThisSubtask(), this.context.getNumberOfParallelSubtasks()));
        while (!this.stop && !this.exitAfterReadFinished) {
            if (this.partitionChangedAfterIdle != null && this.partitionChangedAfterIdle.get()) {
                throw new RuntimeException("Source partitions number changed while the subTask is idle.");
            }
            Thread.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecord(SourceFunction.SourceContext<OUT> ctx, ReaderRunner<OUT, CURSOR> readerRunner) {
        Object object = ctx.getCheckpointLock();
        synchronized (object) {
            Tuple3<OUT, Long, Long> record = readerRunner.pollRecord();
            if (record != null) {
                ctx.collectWithTimestamp(record.f0, ((Long)record.f1).longValue());
                this.maybeSamplingMetric(readerRunner.getSplit().getSplitNumber(), (Long)record.f1);
                this.tpsMetric.markEvent();
                if ((Long)record.f2 > 0L) {
                    this.partitionLatency.update((Long)record.f2);
                }
            }
        }
    }

    private void maybeSamplingMetric(int splitId, long eventTime) {
        this.splitIdToSamplingCount.putIfAbsent(splitId, this.sampleInterval);
        Long count = this.splitIdToSamplingCount.get(splitId);
        if (count + 1L >= this.sampleInterval) {
            long currentEmitEventTimeLag = this.clock.absoluteTimeMillis() - eventTime;
            this.splitIdToEmitLag.put(splitId, currentEmitEventTimeLag);
            this.splitIdToSamplingCount.put(splitId, 0L);
        } else {
            this.splitIdToSamplingCount.put(splitId, count + 1L);
        }
    }

    public Progress<CURSOR> getProgress() throws IOException {
        Progress progress = new Progress();
        for (ReaderRunner readerRunner : this.readerRunners) {
            progress.addProgress(readerRunner.getSplit(), readerRunner.getProgress());
        }
        for (Map.Entry entry : this.exitedReadRunnerSplitCursor.entrySet()) {
            progress.addProgress((InputSplit)entry.getKey(), (Serializable)entry.getValue());
        }
        return progress;
    }

    protected void submitReaders() {
        for (ReaderRunner readerRunner : this.readerRunners) {
            this.readerPool.submit(readerRunner);
            LOG.info(String.format("Start split reader for split[%d][%s]", readerRunner.getSplit().getSplitNumber(), readerRunner.getSplit().toString()));
        }
    }

    @Override
    public long getWatermark() {
        long watermark = Long.MAX_VALUE;
        for (ReaderRunner readerRunner : this.readerRunners) {
            watermark = watermark < readerRunner.getWatermark() ? watermark : readerRunner.getWatermark();
        }
        return watermark;
    }

    public class DelayGauge
    implements Gauge<Long> {
        private final ConcurrentHashMap<Integer, Long> delayStats = new ConcurrentHashMap();
        private BlockingQueue<ReaderRunner<OUT, CURSOR>> readerRunners;
        private DelayKind delayKind;

        public DelayGauge(BlockingQueue<ReaderRunner<OUT, CURSOR>> readerRunners, DelayKind delayKind) {
            this.readerRunners = readerRunners;
            this.delayKind = delayKind;
        }

        public Long getValue() {
            if (this.delayKind == DelayKind.WATERMARK_DELAY) {
                long watermark = ParallelReader.this.getWatermark();
                if (watermark == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                return ParallelReader.this.clock.absoluteTimeMillis() - watermark;
            }
            if (null != this.readerRunners) {
                this.delayStats.clear();
                for (ReaderRunner readerRunner : this.readerRunners) {
                    switch (this.delayKind) {
                        case FETCHED_DELAY: {
                            if (readerRunner.getFetchedDelay() <= 0L) break;
                            this.delayStats.put(readerRunner.getSplit().getSplitNumber(), readerRunner.getFetchedDelay());
                            break;
                        }
                        case NO_DATA_DELAY: {
                            if (readerRunner.getDelay() <= 0L || readerRunner.getFetchedDelay() <= 0L) break;
                            long delay = ParallelReader.this.clock.absoluteTimeMillis() - readerRunner.getDelay();
                            long noDataDelay = delay - readerRunner.getFetchedDelay();
                            if (noDataDelay > 10000L) {
                                this.delayStats.put(readerRunner.getSplit().getSplitNumber(), noDataDelay);
                                break;
                            }
                            this.delayStats.put(readerRunner.getSplit().getSplitNumber(), 0L);
                        }
                    }
                }
            }
            while (true) {
                try {
                    long ret = 0L;
                    for (Map.Entry<Integer, Long> delayState : this.delayStats.entrySet()) {
                        if (ret >= delayState.getValue()) continue;
                        ret = delayState.getValue();
                    }
                    return ret;
                }
                catch (ConcurrentModificationException ignore) {
                    LOG.debug("Unable to report delay statistics", ignore);
                    continue;
                }
                break;
            }
        }
    }

    public static class Progress<CURSOR extends Serializable>
    implements Serializable {
        private Map<InputSplit, CURSOR> splitProgress = new HashMap<InputSplit, CURSOR>();

        public void addProgress(InputSplit split, CURSOR cursor) {
            if (cursor != null) {
                this.splitProgress.put(split, cursor);
            }
        }

        public Map<InputSplit, CURSOR> getProgress() {
            return this.splitProgress;
        }
    }

    protected static class WatermarkEmitter<OUT>
    implements Runnable {
        private volatile boolean stopped = false;
        private ParallelReader provider;
        private SourceFunction.SourceContext<OUT> ctx;
        private long watermarkInterval;

        public WatermarkEmitter(ParallelReader provider, long watermarkInterval, SourceFunction.SourceContext<OUT> ctx) {
            this.provider = provider;
            this.ctx = ctx;
            this.watermarkInterval = watermarkInterval;
        }

        @Override
        public void run() {
            long lastWatermark = 0L;
            while (!this.stopped) {
                Watermark nextWatermark = new Watermark(this.provider.getWatermark());
                if (lastWatermark != nextWatermark.getTimestamp()) {
                    lastWatermark = nextWatermark.getTimestamp();
                    this.ctx.emitWatermark(nextWatermark);
                }
                try {
                    Thread.sleep(this.watermarkInterval);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    protected static class ReaderRunner<OUT, CURSOR extends Serializable>
    implements Runnable,
    WatermarkProvider,
    Comparable<ReaderRunner<OUT, CURSOR>> {
        private final RuntimeContext runtimeContext;
        private final RecordReader<OUT, CURSOR> recordReader;
        private final int splitPipeLen;
        private final long idleInterval;
        private final boolean isTracingMetricEnabled;
        private final long tracingInterval;
        private BlockingDeque<Tuple5<OUT, Long, Long, CURSOR, Long>> splitPipe;
        private InputSplit split;
        private volatile long watermark = Long.MIN_VALUE;
        private volatile CURSOR progress = null;
        private volatile boolean stop = false;
        private volatile boolean stopped = false;
        private volatile boolean finished = false;
        private volatile Throwable cause;
        private volatile Thread currentThread;
        private long outputCount = 0L;
        private long traceStart;

        public ReaderRunner(RecordReader<OUT, CURSOR> recordReader, InputSplit split, CURSOR cursor, RuntimeContext context, int splitPipeLen, long idleInterval, boolean isTracingMetricEnabled, long tracingInterval) {
            this.recordReader = recordReader;
            this.split = split;
            this.progress = cursor;
            this.runtimeContext = context;
            this.splitPipeLen = splitPipeLen;
            this.idleInterval = idleInterval;
            this.isTracingMetricEnabled = isTracingMetricEnabled;
            this.tracingInterval = tracingInterval;
            this.splitPipe = new LinkedBlockingDeque<Tuple5<OUT, Long, Long, CURSOR, Long>>(splitPipeLen);
        }

        public InputSplit getSplit() {
            return this.split;
        }

        @Override
        public void run() {
            try {
                this.recordReader.open(this.split, this.runtimeContext);
                if (this.progress != null) {
                    LOG.info("init progress not null, seek {}", (Object)this.progress);
                    this.recordReader.seek(this.progress);
                }
                this.currentThread = Thread.currentThread();
                while (!this.stop && !this.finished) {
                    if (!this.isTracingMetricEnabled) {
                        this.getNextMessage();
                        continue;
                    }
                    this.traceStart = System.nanoTime();
                    if (this.outputCount % this.tracingInterval == 0L) {
                        this.getNextMessageWithTracing();
                    } else {
                        this.getNextMessage();
                    }
                    ++this.outputCount;
                }
            }
            catch (InterruptedException e) {
                if (!this.stop) {
                    this.cause = e;
                }
                LOG.info("Split reader " + this.split + " is interrupted.", e);
            }
            catch (Throwable e) {
                this.cause = e;
                LOG.error("Split reader " + this.split + " is failed cause: ", e);
            }
            finally {
                block23: {
                    try {
                        if (this.recordReader != null) {
                            LOG.info("Closing split {} reader runner.", (Object)this.split);
                            this.recordReader.close();
                        }
                    }
                    catch (Throwable e) {
                        LOG.error("Exception caught in closing record reader", e);
                        if (this.cause != null) break block23;
                        this.cause = e;
                    }
                }
                this.stopped = true;
                LOG.info("Split reader {} thread will exit.", (Object)this.split);
            }
        }

        private void getNextMessageWithTracing() throws IOException, InterruptedException {
            while (!this.stop && !this.finished) {
                boolean bl = this.finished = !this.recordReader.next();
                if (!this.finished) {
                    if (!this.recordReader.isHeartBeat()) {
                        this.put(this.recordReader.getMessage(), System.nanoTime() - this.traceStart);
                        break;
                    }
                    this.updateWatermarkAndProgress(this.recordReader.getWatermark(), this.recordReader.getProgress());
                    continue;
                }
                LOG.info("Finishing Split {}.", (Object)this.split);
            }
        }

        private void getNextMessage() throws IOException, InterruptedException {
            while (!this.stop && !this.finished) {
                boolean bl = this.finished = !this.recordReader.next();
                if (!this.finished) {
                    if (!this.recordReader.isHeartBeat()) {
                        this.put(this.recordReader.getMessage(), 0L);
                        break;
                    }
                    this.updateWatermarkAndProgress(this.recordReader.getWatermark(), this.recordReader.getProgress());
                    continue;
                }
                LOG.info("Finishing Split {}.", (Object)this.split);
            }
        }

        protected void put(OUT record, long latencyInNanos) throws IOException, InterruptedException {
            Tuple5 tuple = new Tuple5(record, (Object)this.recordReader.getWatermark(), (Object)this.recordReader.getWatermark(), this.recordReader.getProgress(), (Object)latencyInNanos);
            while (!this.stop && !this.splitPipe.offer(tuple, this.idleInterval, TimeUnit.MILLISECONDS)) {
            }
        }

        public void stop() {
            this.stop = true;
            if (this.recordReader instanceof Interruptible) {
                ((Interruptible)((Object)this.recordReader)).interrupt();
            }
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public boolean isExhausted() {
            return this.stop || this.finished && this.splitPipe.isEmpty();
        }

        public Throwable getCause() {
            return this.cause;
        }

        public synchronized void updateWatermarkAndProgress(long watermark, CURSOR progress) {
            Tuple5 current = (Tuple5)this.splitPipe.peekLast();
            if (current != null) {
                current.f2 = watermark;
                current.f3 = progress;
            } else {
                this.watermark = watermark;
                this.progress = progress;
            }
        }

        public boolean hasRecord() {
            return !this.splitPipe.isEmpty();
        }

        public synchronized Tuple3<OUT, Long, Long> pollRecord() {
            Tuple5<OUT, Long, Long, CURSOR, Long> current = this.splitPipe.poll();
            if (current == null) {
                return null;
            }
            this.watermark = (Long)current.f2;
            this.progress = (Serializable)current.f3;
            return new Tuple3(current.f0, current.f1, current.f4);
        }

        public synchronized CURSOR getProgress() throws IOException {
            return this.progress;
        }

        @Override
        public synchronized long getWatermark() {
            return this.watermark;
        }

        @Override
        public int compareTo(ReaderRunner<OUT, CURSOR> o) {
            return Long.compare(this.getWatermark(), o.getWatermark());
        }

        public String getStackTrace() {
            StackTraceElement[] stack;
            if (this.currentThread == null || !this.currentThread.isAlive()) {
                return "No stack trace, maybe thread already exited.";
            }
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement e : stack = this.currentThread.getStackTrace()) {
                sb.append(e).append('\n');
            }
            return sb.toString();
        }

        public long getDelay() {
            return this.recordReader.getDelay();
        }

        public long getFetchedDelay() {
            return this.recordReader.getFetchedDelay();
        }
    }

    public static enum DelayKind {
        FETCHED_DELAY,
        NO_DATA_DELAY,
        WATERMARK_DELAY;

    }
}

