/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source;

import com.alibaba.ververica.connectors.common.source.AbstractParallelSource;
import com.alibaba.ververica.connectors.common.source.AbstractParallelSourceBase;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;

public abstract class AbstractLocatableParallelSource<T, CURSOR extends Serializable>
extends AbstractParallelSource<T, CURSOR> {
    public abstract LocatableInputSplit[] createInputSplitsForCurrentSubTask(int var1, int var2) throws IOException;

    @Override
    public InputFormat<T, InputSplit> getFormat() {
        return new LocatableParallelSourceInputFormatWrapper(this);
    }

    protected static class LocatableParallelSourceInputFormatWrapper<T>
    extends AbstractParallelSourceBase.ParallelSourceInputFormatWrapper<T> {
        public LocatableParallelSourceInputFormatWrapper(AbstractParallelSource<T, ?> source) {
            super(source);
        }

        @Override
        public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
            LocatableInputSplit[] locatableInputSplits = new LocatableInputSplit[inputSplits.length];
            for (int i = 0; i < inputSplits.length; ++i) {
                locatableInputSplits[i] = (LocatableInputSplit)inputSplits[i];
            }
            if (this.source.isParallelReadDisabled()) {
                return new LocatableInputSplitAssigner(locatableInputSplits);
            }
            return super.getInputSplitAssigner(inputSplits);
        }
    }
}

