/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.natives;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;

@PublicEvolving
public class NativeOptions {
    public static final String NATIVE_ENGINE_OPTIONS_PREFIX = "native-engine.";
    @Documentation.Section(value={"all_native_engine"})
    public static final ConfigOption<Boolean> NATIVE_ENGINE_ENABLED = ConfigOptions.key((String)"native-engine.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to enable flink native engine or not.");
    @Documentation.Section(value={"all_native_engine"})
    public static final ConfigOption<Integer> NATIVE_ENGINE_BATCH_SIZE = ConfigOptions.key((String)"native-engine.batch.size").intType().defaultValue((Object)1024).withDescription("The expected batch size for native engine.");
    @Documentation.Section(value={"all_native_engine"})
    public static final ConfigOption<String> NATIVE_LOOKUP_HANDLE_ADDR = ConfigOptions.key((String)"$internal.native-engine.lookup.handle.addr").stringType().defaultValue((Object)"0").withDescription("The config to save address of native lookup operator.");
    @Documentation.Section(value={"all_taskmanager"})
    public static final ConfigOption<Integer> NATIVE_ENGINE_ASYNC_PROCESSING_BUFFER_SIZE = ConfigOptions.key((String)"native-engine.async-processing.buffer.size").intType().defaultValue((Object)(4 * (Integer)NATIVE_ENGINE_BATCH_SIZE.defaultValue())).withDescription("The max number of records can be buffered for async processing.");
    @Documentation.ExcludeFromDocumentation(value="Work around before simd parser share memory pool with native engine.")
    public static final ConfigOption<MemorySize> NATIVE_ENGINE_SIMD_PARSER_MEM_POOL_SIZE = ConfigOptions.key((String)"native-engine.simd-parser.mem-pool.size").memoryType().defaultValue((Object)MemorySize.ofMebiBytes((long)64L)).withDescription("The memory pool size of simd parser.");
    @Documentation.Section(value={"all_native_engine"})
    public static final ConfigOption<Integer> NATIVE_SHUFFLE_BUFFER_BATCHES_PER_CHANNEL = ConfigOptions.key((String)"native-engine.shuffle-buffer.batches-per-channel").intType().defaultValue((Object)8).withDescription("The maximum number of batches of elements buffered for each incoming channel.");

    private NativeOptions() {
    }
}

