/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.natives.memory.NativeMemoryPool;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeAllCacheSharedResource {
    private static final Logger LOG = LoggerFactory.getLogger(NativeAllCacheSharedResource.class);
    private final NativeMemoryPool memoryPool;
    private static long quota = -1L;
    private static volatile NativeAllCacheSharedResource instance;

    private NativeAllCacheSharedResource() {
        Preconditions.checkArgument((quota > 0L ? 1 : 0) != 0, (Object)("When native engine is enabled, users must specify " + TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key() + " to cache the lookup table for native lookup join usage."));
        this.memoryPool = NativeMemoryPool.createInstance((String)"lookup-all-cache", (long)quota);
    }

    public static synchronized void setQuota(long quota) {
        NativeAllCacheSharedResource.quota = quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NativeAllCacheSharedResource getInstance() {
        if (instance != null) return instance;
        Class<NativeAllCacheSharedResource> clazz = NativeAllCacheSharedResource.class;
        synchronized (NativeAllCacheSharedResource.class) {
            if (instance != null) return instance;
            LOG.info("The native memory pool of quota: {} bytes is created.", (Object)quota);
            instance = new NativeAllCacheSharedResource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void close() throws Exception {
        if (instance == null) {
            LOG.warn("You are trying to close the uninitialized NativeAllCacheSharedResource.");
        } else {
            instance.getMemoryPool().close();
        }
    }

    public NativeMemoryPool getMemoryPool() {
        return this.memoryPool;
    }
}

