/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.provider.CLIProfileCredentialsProvider;
import com.aliyun.auth.credentials.provider.CredentialsProviderChain;
import com.aliyun.auth.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.auth.credentials.provider.EnvironmentVariableCredentialProvider;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.auth.credentials.provider.ProfileCredentialProvider;
import com.aliyun.auth.credentials.provider.SystemPropertiesCredentialProvider;
import com.aliyun.auth.credentials.provider.URLCredentialProvider;
import com.aliyun.auth.credentials.utils.AuthUtils;
import com.aliyun.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DefaultCredentialProvider
implements ICredentialProvider {
    private List<ICredentialProvider> customizeProviders;
    private final CredentialsProviderChain providerChain;

    private DefaultCredentialProvider(Builder builder) {
        this.customizeProviders = builder.customizeProviders;
        this.providerChain = this.createChain(builder);
    }

    private CredentialsProviderChain createChain(Builder builder) {
        boolean asyncCredentialUpdateEnabled = builder.asyncCredentialUpdateEnabled;
        boolean reuseLastProviderEnabled = builder.reuseLastProviderEnabled;
        if (this.customizeProviders.isEmpty()) {
            String uri;
            this.customizeProviders.add(SystemPropertiesCredentialProvider.create());
            this.customizeProviders.add(EnvironmentVariableCredentialProvider.create());
            if (AuthUtils.environmentEnableOIDC()) {
                this.customizeProviders.add(OIDCRoleArnCredentialProvider.builder().roleArn(AuthUtils.getEnvironmentRoleArn()).oidcProviderArn(AuthUtils.getEnvironmentOIDCProviderArn()).oidcTokenFilePath(AuthUtils.getEnvironmentOIDCTokenFilePath()).build());
            }
            this.customizeProviders.add(CLIProfileCredentialsProvider.builder().build());
            this.customizeProviders.add(ProfileCredentialProvider.builder().profileFile(builder.profileFile).clientType(builder.clientType).asyncCredentialUpdateEnabled(asyncCredentialUpdateEnabled).build());
            if (!AuthUtils.isDisableECSMetaData()) {
                this.customizeProviders.add(EcsRamRoleCredentialProvider.builder().build());
            }
            if (!StringUtils.isEmpty((CharSequence)(uri = AuthUtils.getEnvironmentCredentialsURI()))) {
                this.customizeProviders.add(URLCredentialProvider.builder().credentialsURI(uri).build());
            }
        }
        return CredentialsProviderChain.builder().reuseLastProviderEnabled(reuseLastProviderEnabled).credentialsProviders(this.customizeProviders).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ICredential getCredentials() {
        return this.providerChain.getCredentials();
    }

    public Boolean containsCredentialProvider(ICredentialProvider provider) {
        return this.customizeProviders.contains(provider);
    }

    public void close() {
        this.providerChain.close();
    }

    public String toString() {
        HashMap<String, CredentialsProviderChain> fieldMap = new HashMap<String, CredentialsProviderChain>();
        fieldMap.put("providerChain", this.providerChain);
        return StringUtils.toAliString((String)"DefaultCredentialsProvider", fieldMap);
    }

    public static final class Builder {
        private String profileFile;
        private String clientType;
        private Boolean reuseLastProviderEnabled = true;
        private Boolean asyncCredentialUpdateEnabled = false;
        private List<ICredentialProvider> customizeProviders = new ArrayList<ICredentialProvider>();

        public Builder profileFile(String profileFile) {
            this.profileFile = profileFile;
            return this;
        }

        public Builder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public Builder reuseLastProviderEnabled(Boolean reuseLastProviderEnabled) {
            this.reuseLastProviderEnabled = reuseLastProviderEnabled;
            return this;
        }

        public Builder asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return this;
        }

        public Builder customizeProviders(Collection<? extends ICredentialProvider> customizeProviders) {
            this.customizeProviders = new ArrayList<ICredentialProvider>(customizeProviders);
            return this;
        }

        public Builder customizeProviders(ICredentialProvider ... customizeProviders) {
            return this.customizeProviders(Arrays.asList(customizeProviders));
        }

        public Builder addCustomizeProviders(ICredentialProvider credentialsProviders) {
            this.customizeProviders.add(credentialsProviders);
            return this;
        }

        public DefaultCredentialProvider build() {
            return new DefaultCredentialProvider(this);
        }
    }
}

