/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.mapred.unittest.MRUnitTest;
import com.aliyun.odps.mapred.unittest.UTContext;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MapUTContext
extends UTContext {
    private List<Record> records = new ArrayList<Record>();
    private String inputSchema = null;

    public void addInputRecord(Record record) {
        this.records.add(record);
    }

    public void addInputRecords(Collection<Record> records) {
        this.records.addAll(records);
    }

    public void addInputRecordsFromDir(File dir) throws IOException {
        if (!dir.exists()) {
            throw new RuntimeException(dir.getAbsolutePath() + " : input dir not exists!");
        }
        this.addInputRecords(MRUnitTest.readRecords(dir));
    }

    public List<Record> getInputRecords() {
        return this.records;
    }

    public void clearInputRecords() {
        this.records.clear();
    }

    public void setInputSchema(String inputSchema) throws IOException {
        try {
            SchemaUtils.fromString((String)inputSchema.trim());
        }
        catch (Exception ex) {
            throw new IOException("bad schema format: " + inputSchema);
        }
        this.inputSchema = inputSchema;
    }

    public String getInputSchema() {
        return this.inputSchema;
    }

    public Record createInputRecord() throws IOException {
        if (this.inputSchema == null) {
            throw new IOException("input schema is not set.");
        }
        return MRUnitTest.createRecord(this.inputSchema);
    }
}

