/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.mapred.unittest;

import com.aliyun.odps.Column;
import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.counter.Counter;
import com.aliyun.odps.counter.CounterGroup;
import com.aliyun.odps.counter.Counters;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.local.common.FileSplit;
import com.aliyun.odps.local.common.TableMeta;
import com.aliyun.odps.local.common.WareHouse;
import com.aliyun.odps.local.common.utils.ArchiveUtils;
import com.aliyun.odps.local.common.utils.LocalRunUtils;
import com.aliyun.odps.mapred.TaskId;
import com.aliyun.odps.mapred.bridge.WritableRecord;
import com.aliyun.odps.mapred.conf.BridgeJobConf;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.local.CSVRecordReader;
import com.aliyun.odps.mapred.local.CSVRecordWriter;
import com.aliyun.odps.mapred.local.JobCounter;
import com.aliyun.odps.mapred.local.LocalTaskId;
import com.aliyun.odps.mapred.local.MapDriver;
import com.aliyun.odps.mapred.local.ReduceDriver;
import com.aliyun.odps.mapred.unittest.KeyValue;
import com.aliyun.odps.mapred.unittest.LocalRecordComparator;
import com.aliyun.odps.mapred.unittest.MapUTContext;
import com.aliyun.odps.mapred.unittest.ReduceUTContext;
import com.aliyun.odps.mapred.unittest.RuntimeContext;
import com.aliyun.odps.mapred.unittest.TaskOutput;
import com.aliyun.odps.mapred.unittest.UTContext;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import com.aliyun.odps.pipeline.Pipeline;
import com.aliyun.odps.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MRUnitTest {
    private static final Log LOG = LogFactory.getLog(MRUnitTest.class);
    private static String DEFAULT_PROJECT_NAME = "default_mr_unittest";
    private static String DEFAULT_TABLE_NAME = "default_mr_unittest_table";

    public TaskOutput runMapper(JobConf job, MapUTContext context) throws IOException, ClassNotFoundException, InterruptedException {
        Pipeline pipeline = Pipeline.fromJobConf((JobConf)job);
        String jobId = this.generateMrTaskName();
        LOG.info((Object)("start to run mapper unittest, id: " + jobId));
        RuntimeContext ctx = RuntimeContext.create(jobId, job);
        TableInfo[] inputTableInfos = InputUtils.getTables((JobConf)job);
        ArrayList<FileSplit> inputs = new ArrayList<FileSplit>();
        context.setRuntimeContext(ctx);
        this.writeJobConf(job, ctx);
        this.processInputs(job, inputs, context);
        this.processResources(job, context);
        int mapCopyNum = 0;
        int reduceCopyNum = 0;
        mapCopyNum = inputTableInfos != null && inputTableInfos.length > 0 ? inputTableInfos.length : job.getInt("odps.stage.mapper.num", 1);
        Pipeline.TransformNode pipeNode = pipeline == null ? null : pipeline.getFirstNode();
        reduceCopyNum = this.computeReduceNum(mapCopyNum, pipeNode, job, ctx);
        LocalTaskId taskId = new LocalTaskId("M1", 0, DEFAULT_PROJECT_NAME);
        TaskOutput mapOutput = pipeline == null ? new TaskOutput(job, reduceCopyNum) : new TaskOutput(job, pipeline, taskId.getTaskId(), reduceCopyNum);
        Counters counters = new Counters();
        for (int mapId = 0; mapId < mapCopyNum; ++mapId) {
            FileSplit split = inputs.size() > 0 ? (FileSplit)inputs.get(mapId) : FileSplit.NullSplit;
            taskId = new TaskId("M1", mapId + 1);
            LOG.info((Object)("Start to run mapper, TaskId: " + (Object)((Object)taskId)));
            BridgeJobConf conf = new BridgeJobConf((Configuration)job);
            MapDriver mapDriver = new MapDriver(conf, split, taskId, mapOutput, counters, inputTableInfos == null ? null : inputTableInfos[mapId]);
            mapDriver.run();
        }
        Counters userCounters = new Counters();
        this.printCounters(counters, userCounters);
        mapOutput.setCounters(userCounters);
        this.clean(context);
        return mapOutput;
    }

    private void processResources(JobConf job, UTContext context) throws IOException {
        RuntimeContext ctx = context.getRuntimeContext();
        Map<String, byte[]> fileResources = context.getFileResources();
        for (Map.Entry<String, byte[]> entry : fileResources.entrySet()) {
            LOG.info((Object)("process file resource: " + entry.getKey()));
            File file = new File(ctx.getResourceDir(), entry.getKey());
            FileUtils.writeByteArrayToFile((File)file, (byte[])entry.getValue());
        }
        Map<String, File> archiveResources = context.getArchiveResources();
        for (Map.Entry<String, File> entry : archiveResources.entrySet()) {
            LOG.info((Object)("process archive resource: " + entry.getKey()));
            File resDecompressedDir = new File(ctx.getResourceDir(), entry.getKey() + "_decompressed");
            File resFile = new File(ctx.getResourceDir(), entry.getKey());
            File path = entry.getValue();
            if (path.isFile()) {
                FileUtils.copyFile((File)path, (File)resFile);
                ArchiveUtils.unArchive((File)resFile, (File)resDecompressedDir);
                continue;
            }
            resFile.createNewFile();
            FileUtils.copyDirectoryToDirectory((File)path, (File)resDecompressedDir);
        }
        Map<String, List<Record>> map = context.getTableResources();
        Map<String, TableMeta> map2 = context.getTableMetas();
        for (Map.Entry<String, List<Record>> entry : map.entrySet()) {
            LOG.info((Object)("process table resource: " + entry.getKey()));
            File resDir = new File(ctx.getResourceDir(), entry.getKey());
            MRUnitTest.writeRecords(resDir, entry.getValue(), map2.get(entry.getKey()));
        }
        context.clearResources();
    }

    private String generateMrTaskName() {
        return "mr_ut_" + LocalRunUtils.getDateFormat((String)"yyyyMMddHHmmss_SSS").format(new Date());
    }

    private void processInputs(JobConf conf, List<FileSplit> inputs, MapUTContext context) throws IOException {
        TableInfo[] inputTableInfos = InputUtils.getTables((JobConf)conf);
        if (inputTableInfos == null) {
            LOG.debug((Object)"No input tables to process");
            return;
        }
        for (TableInfo tableInfo : inputTableInfos) {
            LOG.debug((Object)("Start to process input table: " + tableInfo));
            if (StringUtils.isEmpty((String)tableInfo.getProjectName())) {
                tableInfo.setProjectName(DEFAULT_PROJECT_NAME);
            }
            this.processMapInputs(conf, inputs, context, tableInfo);
            LOG.debug((Object)("Finished process input table: " + tableInfo));
        }
        if (inputs.isEmpty()) {
            inputs.add(FileSplit.NullSplit);
        }
    }

    public TaskOutput runReducer(JobConf job, ReduceUTContext context) throws IOException, ClassNotFoundException, InterruptedException {
        Pipeline pipeline = Pipeline.fromJobConf((JobConf)job);
        String jobId = this.generateMrTaskName();
        LOG.info((Object)("start to run mapper unittest, id: " + jobId));
        RuntimeContext ctx = RuntimeContext.create(jobId, job);
        context.setRuntimeContext(ctx);
        this.writeJobConf(job, ctx);
        int mapCopyNum = 1;
        int reduceCopyNum = 0;
        Pipeline.TransformNode pipeNode = pipeline == null ? null : pipeline.getNode(context.getReducerIndex() + 1);
        int reduceIndx = pipeline == null ? 2 : 2 + context.getReducerIndex();
        reduceCopyNum = this.computeReduceNum(mapCopyNum, pipeNode, job, ctx);
        LocalTaskId preTaskId = new LocalTaskId(reduceIndx == 2 ? "M1" : "R" + Integer.toString(reduceIndx - 1), 0, DEFAULT_PROJECT_NAME);
        TaskOutput reduceInput = pipeline == null ? new TaskOutput(job, reduceCopyNum) : new TaskOutput(job, pipeline, preTaskId.getTaskId(), reduceCopyNum);
        for (KeyValue<Record, Record> kv : context.getInputKeyVals()) {
            reduceInput.add(kv.getKey(), kv.getValue());
        }
        this.processResources(job, context);
        LocalTaskId taskId = new LocalTaskId("R" + Integer.toString(reduceIndx), 0, DEFAULT_PROJECT_NAME);
        TaskOutput reduceOutput = pipeline == null ? new TaskOutput(job, reduceCopyNum) : new TaskOutput(job, pipeline, taskId.getTaskId(), reduceCopyNum);
        Counters counters = new Counters();
        for (int reduceId = 0; reduceId < reduceCopyNum; ++reduceId) {
            taskId = new TaskId("R" + Integer.toString(reduceIndx), reduceId);
            LOG.info((Object)("Start to run reduce, taskId: " + (Object)((Object)taskId)));
            BridgeJobConf conf = new BridgeJobConf((Configuration)job);
            ReduceDriver reduceDriver = new ReduceDriver(conf, reduceInput, reduceOutput, taskId, counters, reduceId);
            reduceDriver.run();
            LOG.info((Object)("Finished run reduce, taskId: " + (Object)((Object)taskId)));
        }
        Counters userCounters = new Counters();
        this.printCounters(counters, userCounters);
        reduceOutput.setCounters(userCounters);
        this.clean(context);
        return reduceOutput;
    }

    public static Record createRecord(String schema) throws IOException {
        return new WritableRecord(SchemaUtils.fromString((String)schema));
    }

    public static List<Record> readRecords(File dir) throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        TableMeta meta = com.aliyun.odps.local.common.utils.SchemaUtils.readSchema((File)dir);
        File dataFile = new File(dir, "data");
        if (!dataFile.exists()) {
            return records;
        }
        Counters counters = new Counters();
        Counter emptyCounter = counters.findCounter((Enum)JobCounter.__EMPTY_WILL_NOT_SHOW);
        CSVRecordReader reader = new CSVRecordReader(new FileSplit(dataFile, meta.getCols(), 0L, dataFile.getTotalSpace()), meta, emptyCounter, emptyCounter, counters, WareHouse.getInstance().getInputColumnSeperator());
        Record r = reader.read();
        while (r != null) {
            records.add(r.clone());
            r = reader.read();
        }
        reader.close();
        return records;
    }

    public static void writeRecords(File dir, List<Record> records, TableMeta meta) throws IOException {
        if (StringUtils.isEmpty((String)meta.getProjName())) {
            meta.setProjName(DEFAULT_PROJECT_NAME);
        }
        if (StringUtils.isEmpty((String)meta.getTableName())) {
            meta.setTableName(DEFAULT_TABLE_NAME);
        }
        dir.mkdirs();
        com.aliyun.odps.local.common.utils.SchemaUtils.generateSchemaFile((TableMeta)meta, null, (File)dir);
        File file = new File(dir, "data");
        file.createNewFile();
        CSVRecordWriter writer = new CSVRecordWriter(file, null, null, RuntimeContext.getWareHouse().getInputColumnSeperator());
        for (Record record : records) {
            writer.write(record);
        }
        writer.close();
    }

    public static boolean equalRecords(List<Record> records1, List<Record> records2, boolean sort) {
        ArrayList<Record> list1 = new ArrayList<Record>(records1);
        ArrayList<Record> list2 = new ArrayList<Record>(records2);
        LocalRecordComparator comparator = new LocalRecordComparator();
        if (sort) {
            Collections.sort(list1, comparator);
            Collections.sort(list2, comparator);
        }
        boolean comp = list1.size() == records2.size();
        for (int i = 0; i < list1.size() && comp; ++i) {
            comp = comparator.compare((Record)list1.get(i), (Record)list2.get(i)) == 0;
        }
        return comp;
    }

    public static boolean equalRecords(File dir, List<Record> records, boolean sort) throws IOException {
        List<Record> list = MRUnitTest.readRecords(dir);
        return MRUnitTest.equalRecords(list, records, sort);
    }

    private void processMapInputs(JobConf job, List<FileSplit> inputs, MapUTContext context, TableInfo tblInfo) throws IOException {
        LOG.info((Object)("process map input: " + tblInfo));
        RuntimeContext ctx = context.getRuntimeContext();
        String projName = tblInfo.getProjectName();
        String tblName = tblInfo.getTableName();
        String fullName = projName + "." + tblName;
        String partSpec = tblInfo.getPartPath();
        String s = context.getInputSchema();
        if (s == null) {
            throw new IOException("input schema is not set.");
        }
        Column[] cols = SchemaUtils.fromString((String)s.trim());
        TableMeta meta = new TableMeta(projName, tblName, cols, null);
        File tblDir = ctx.getInputDir(fullName, partSpec);
        this.prepareTableDir(meta, inputs, tblDir, context.getInputRecords());
    }

    private void prepareTableDir(TableMeta meta, List<FileSplit> inputs, File tblDir, List<Record> records) throws IOException {
        String tbl = meta.getProjName() + "." + meta.getTableName();
        LOG.info((Object)("prepare table dir: " + tbl + " to " + tblDir.getAbsolutePath()));
        MRUnitTest.writeRecords(tblDir, records, meta);
        File file = new File(tblDir, "data");
        FileSplit split = new FileSplit(file, meta.getCols(), 0L, file.length());
        inputs.add(split);
    }

    private void clean(UTContext context) throws IOException {
        if (context.isCleanUtDir()) {
            FileUtils.deleteDirectory((File)context.runtimeContext.getJobDir());
        }
    }

    private void writeJobConf(JobConf job, RuntimeContext ctx) throws IOException {
        FileOutputStream fos = new FileOutputStream(ctx.getJobFile());
        job.writeXml((OutputStream)fos);
        fos.close();
    }

    private int computeReduceNum(int mapNum, Pipeline.TransformNode pipeNode, JobConf conf, RuntimeContext ctx) throws IOException {
        int reduceNum = 1;
        reduceNum = pipeNode != null ? (pipeNode.getNextNode() != null ? pipeNode.getNextNode().getNumTasks() : pipeNode.getNumTasks()) : (ctx.containsKey("odps.stage.reducer.num") ? conf.getNumReduceTasks() : Math.max(1, mapNum / 4));
        if (reduceNum < 0) {
            throw new IOException("ODPS-0720251: Num of reduce instance is invalid - reduce num cann't be less than 0");
        }
        if (reduceNum != conf.getNumReduceTasks()) {
            LOG.info((Object)("change reduce num from " + conf.getNumReduceTasks() + " to " + reduceNum));
        }
        conf.setNumReduceTasks(reduceNum);
        return reduceNum;
    }

    private void printCounters(Counters counters, Counters userCounters) {
        int totalCount = 0;
        int frameWorkCounterCount = 0;
        int jobCounterCount = 0;
        int userCounterCount = 0;
        for (CounterGroup group : counters) {
            for (Counter counter : group) {
                if (counter.getDisplayName().startsWith("__EMPTY_")) continue;
                if (group.getDisplayName().equals(JobCounter.class.getName())) {
                    ++frameWorkCounterCount;
                } else if (group.getDisplayName().equals("com.aliyun.odps.mapred.local.Counter.JobCounter")) {
                    ++jobCounterCount;
                } else {
                    ++userCounterCount;
                }
                ++totalCount;
            }
        }
        StringBuilder sb = new StringBuilder("Counters: " + totalCount);
        sb.append("\n\tMap-Reduce Framework: " + frameWorkCounterCount);
        for (CounterGroup group : counters) {
            if (!group.getDisplayName().equals(JobCounter.class.getName())) continue;
            for (Counter counter : group) {
                if (counter.getDisplayName().startsWith("__EMPTY_")) continue;
                sb.append("\n\t\t" + counter.getDisplayName() + "=" + counter.getValue());
            }
        }
        sb.append("\n\tUser Defined Counters: " + userCounterCount);
        for (CounterGroup group : counters) {
            if (group.getDisplayName().equals(JobCounter.class.getName()) || group.getDisplayName().equals("com.aliyun.odps.mapred.local.Counter.JobCounter")) continue;
            sb.append("\n\t\t" + group.getDisplayName());
            for (Counter counter : group) {
                if (counter.getDisplayName().equals(JobCounter.__EMPTY_WILL_NOT_SHOW.toString())) continue;
                userCounters.findCounter(group.getDisplayName(), counter.getDisplayName()).setValue(counter.getValue());
                sb.append("\n\t\t\t" + counter.getDisplayName() + "=" + counter.getValue());
            }
        }
        System.err.println(sb.toString());
    }
}

