/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.cupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.cupid.common.CupidSessionConf;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListCupidInstancesCommand
extends AbstractCommand {
    private CupidSession cupidSession = null;
    public static final String[] HELP_TAGS = new String[]{"cupid", "list", "ls", "instance", "instances"};

    public ListCupidInstancesCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
        CupidConf cupidConf = CupidSessionConf.getBasicCupidConf(this.getContext());
        this.cupidSession = new CupidSession(cupidConf);
    }

    private String getAppStateStr(long order) throws ODPSConsoleException {
        AppState[] states = AppState.values();
        if (order >= (long)states.length || order < 0L) {
            throw new ODPSConsoleException("Cupid application state illegal: " + order);
        }
        return states[(int)order].name();
    }

    public void run() throws OdpsException, ODPSConsoleException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = null;
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta(null, null, (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new ODPSConsoleException((Throwable)ex);
        }
        String[] title = new String[]{"StartTime", "RunTime", "Status", "InstanceID"};
        int[] columnPercent = new int[]{15, 6, 6, 20};
        ODPSConsoleUtils.formaterTableRow((String[])title, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        String[] attr = new String[4];
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            String sState;
            String instanceId;
            attr[3] = instanceId = applicationMeta.getInstanceId();
            long intState = applicationMeta.getYarnApplicationState();
            attr[2] = sState = this.getAppStateStr(intState);
            long sTime = applicationMeta.getStartedTime();
            Date date = new Date(sTime);
            attr[0] = ODPSConsoleUtils.formatDate((Date)date);
            long eTime = applicationMeta.getFinishedTime();
            long rTime = 0L;
            rTime = intState == (long)AppState.FAILED.ordinal() || intState == (long)AppState.FAILED.ordinal() || intState == (long)AppState.KILLED.ordinal() ? eTime - sTime : System.currentTimeMillis() - sTime;
            attr[1] = rTime / 1000L + "s";
            ODPSConsoleUtils.formaterTableRow((String[])attr, (int[])columnPercent, (int)this.getContext().getConsoleWidth());
        }
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: list|ls cupidinstances");
        stream.println();
    }

    public static ListCupidInstancesCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        String regstr = "\\s*(list|ls)\\s+cupidinstances([\\s\\S]*)";
        Pattern pattern = Pattern.compile(regstr, 2);
        Matcher matcher = pattern.matcher(cmd);
        if (matcher.matches()) {
            return new ListCupidInstancesCommand(cmd, cxt);
        }
        return null;
    }

    private static enum AppState {
        NEW,
        NEW_SAVING,
        SUBMITTED,
        ACCEPTED,
        RUNNING,
        FINISHED,
        FAILED,
        KILLED;

    }
}

