/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.cupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.odps.cupid.requestcupid.YarnClientImplUtil;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.cupid.common.CupidSessionConf;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class GetJobViewCommand
extends AbstractCommand {
    private String instanceID;
    private static final Options options = GetJobViewCommand.initOptions();
    public static final String[] HELP_TAGS = new String[]{"cupid", "wait", "jobview"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: wait jobview -i <instanceID>");
        stream.println("Get jobview url whose ID is <instanceID>");
        stream.println();
    }

    public GetJobViewCommand(String commandText, ExecutionContext context, String[] args) throws ODPSConsoleException {
        super(commandText, context);
        try {
            this.parseArgs(args);
        }
        catch (ParseException e) {
            GetJobViewCommand.printUsage(System.err);
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
    }

    public static GetJobViewCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        String regstr = "\\s*wait\\s+jobview([\\s\\S]*)";
        Pattern pattern = Pattern.compile(regstr, 2);
        Matcher matcher = pattern.matcher(cmd);
        if (matcher.matches()) {
            String args = matcher.group(1).replaceAll("\\s+", " ").trim();
            return new GetJobViewCommand(cmd, cxt, args.split(" "));
        }
        return null;
    }

    private static Options initOptions() {
        Options options = new Options();
        Option instanceIDOption = new Option("i", "instanceID", true, "instance ID");
        instanceIDOption.setRequired(true);
        options.addOption(instanceIDOption);
        return options;
    }

    private void parseArgs(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        this.instanceID = cmd.getOptionValue("instanceID");
    }

    public void run() throws OdpsException, ODPSConsoleException {
        CupidTaskParamProtos.ApplicationMeta applicationMeta;
        CupidConf cupidConf = CupidSessionConf.getBasicCupidConf(this.getContext());
        CupidSession cupidSession = new CupidSession(cupidConf);
        cupidSession.setJobLookupName(this.instanceID);
        try {
            applicationMeta = ApplicationMetaUtil.getCupidInstanceMeta((String)this.instanceID, (CupidSession)cupidSession);
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Getting Cupid Instance Meta failed: " + e.getMessage(), (Throwable)e);
        }
        if (applicationMeta == null) {
            throw new ODPSConsoleException("Getting Cupid Instance Meta failed. ");
        }
        Instance currentInstance = cupidSession.odps().instances().get(this.instanceID);
        String jobViewUrl = YarnClientImplUtil.genCupidTrackUrl((Instance)currentInstance, (String)applicationMeta.getApplicationId(), (String)"", (CupidSession)cupidSession);
        if (jobViewUrl == null) {
            throw new ODPSConsoleException("Getting jobView url failed. ");
        }
        this.getWriter().writeIntermediateError("jobView url: ");
        this.getWriter().writeError(" " + jobViewUrl);
    }

    String getInstanceID() {
        return this.instanceID;
    }
}

