/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.cupid;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.cupid.common.CupidSessionConf;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DescribeCupidInstanceCommand
extends AbstractCommand {
    private String instanceID;
    public static final String[] HELP_TAGS = new String[]{"cupid", "desc", "describe"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: describe|desc cupid instance -i <instanceID>");
        stream.println("       Get details information of a cupid instance like a kubernetes cluster or a yarn cluster whose ID is <instanceID>");
        stream.println();
    }

    private DescribeCupidInstanceCommand(String commandText, ExecutionContext context, String[] args) throws ODPSConsoleException {
        super(commandText, context);
        try {
            this.parseArgs(args);
        }
        catch (ParseException e) {
            DescribeCupidInstanceCommand.printUsage(System.err);
            throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
        }
    }

    public static DescribeCupidInstanceCommand parse(String cmd, ExecutionContext cxt) throws ODPSConsoleException {
        String regstr = "\\s*(describe|desc)\\s+(?:cupid)\\s+instance([\\s\\S]*)";
        Pattern pattern = Pattern.compile(regstr, 2);
        Matcher matcher = pattern.matcher(cmd);
        if (matcher.matches()) {
            String args = matcher.group(2).replaceAll("\\s+", " ").trim();
            return new DescribeCupidInstanceCommand(cmd, cxt, args.split(" "));
        }
        return null;
    }

    private static Options initDescribeOptions() {
        Options options = new Options();
        Option instanceIDOption = new Option("i", "instanceID", true, "instance ID");
        instanceIDOption.setRequired(true);
        options.addOption(instanceIDOption);
        return options;
    }

    private void parseArgs(String[] args) throws ParseException, ODPSConsoleException {
        Options options = DescribeCupidInstanceCommand.initDescribeOptions();
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        this.instanceID = cmd.getOptionValue("instanceID");
    }

    public void run() throws ODPSConsoleException {
        this.describeCupidInstance();
    }

    private void describeCupidInstance() throws ODPSConsoleException {
        CupidConf cupidConf = CupidSessionConf.getBasicCupidConf(this.getContext());
        CupidSession cupidSession = new CupidSession(cupidConf);
        try {
            CupidTaskParamProtos.ApplicationMeta applicationMeta = ApplicationMetaUtil.getCupidInstanceMeta((String)this.instanceID, (CupidSession)cupidSession);
            if (applicationMeta == null) {
                throw new ODPSConsoleException("Getting Cupid Instance Meta failed. ");
            }
            this.getWriter().writeError("");
            this.getWriter().writeResult(applicationMeta.toString());
        }
        catch (Exception e) {
            throw new ODPSConsoleException("Getting Cupid Instance Meta failed: " + e.getMessage(), (Throwable)e);
        }
    }

    String getInstanceID() {
        return this.instanceID;
    }
}

