/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.jline.ODPSLineReader;
import org.jline.terminal.Terminal;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class SignalUtil {
    public static void registerSignalHandler(String signalName, SignalHandler handler) {
        if (ODPSConsoleUtils.isWindows()) {
            Signal.handle(new Signal(signalName), handler);
        } else {
            Terminal.Signal jlineSignal = Terminal.Signal.valueOf((String)signalName);
            Terminal.SignalHandler jlineSignalHandler = signal1 -> handler.handle(new Signal(signalName));
            ODPSLineReader.getInstance().registerSignalHandler(jlineSignal, jlineSignalHandler);
        }
    }

    public static SignalHandler getInstanceRunningIntSignalHandler(Thread currentThread) {
        return signal -> {
            SignalUtil.registerSignalHandler("INT", SignalUtil.getDefaultIntSignalHandler(currentThread));
            currentThread.interrupt();
        };
    }

    public static SignalHandler getDefaultIntSignalHandler(Thread currentThread) {
        return signal -> {
            if (currentThread.isInterrupted()) {
                System.exit(128 + new Signal("INT").getNumber());
            } else {
                currentThread.interrupt();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (currentThread.isInterrupted()) {
                    System.err.println("Press Ctrl-C again to exit ODPS console");
                }
            }
        };
    }
}

