/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.utils;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.output.state.InstanceSuccess;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryUtil {
    private static final Pattern PATTERN = Pattern.compile("^Sub-Query:\\s+\\{(.*),[\\s\\S]*\\}\\s*summary:", 34);

    public static HashMap<String, String> getTaskConfig() {
        HashMap<String, String> taskConfig = new HashMap<String, String>();
        if (!SetCommand.setMap.isEmpty()) {
            taskConfig.put("settings", new GsonBuilder().disableHtmlEscaping().create().toJson(SetCommand.setMap));
        }
        if (!SetCommand.aliasMap.isEmpty()) {
            taskConfig.put("aliases", new GsonBuilder().disableHtmlEscaping().create().toJson(SetCommand.aliasMap));
        }
        return taskConfig;
    }

    public static boolean isOperatorDisabled(String sql) {
        String upSql = sql.toUpperCase();
        if (upSql.matches("^INSERT\\s+INTO.*")) {
            return true;
        }
        if (upSql.contains("INSERT ") && upSql.contains(" PARTITION")) {
            String[] partitions = upSql.split(" PARTITION");
            for (int i = 0; i < partitions.length; ++i) {
                String partitionStr;
                String[] partitionSpcs;
                String lastPartitionSpc;
                String temp = partitions[i].trim();
                if (!temp.startsWith("(") || temp.indexOf(")") <= 0 || (lastPartitionSpc = (partitionSpcs = (partitionStr = temp.substring(0, temp.indexOf(")"))).split(","))[partitionSpcs.length - 1]).contains("=")) continue;
                return true;
            }
        }
        return false;
    }

    public static void printSubQueryLogview(Odps odps, Instance i, String taskName, ExecutionContext context) throws OdpsException {
        ArrayList<String> subId = new ArrayList<String>();
        try {
            String summary = InstanceSuccess.getTaskSummaryV1(odps, i, taskName, context.getOutputWriter()).getSummaryText();
            for (String txt : summary.split("\n")) {
                Matcher matcher = PATTERN.matcher(txt = txt.trim());
                if (!matcher.matches()) continue;
                subId.add(matcher.group(1).trim());
            }
            for (String id : subId) {
                Instance subInstance = odps.instances().get(id);
                if (subInstance == null) continue;
                InstanceRunner subRunner = new InstanceRunner(odps, subInstance, context);
                subRunner.printLogview();
            }
        }
        catch (Exception e) {
            context.getOutputWriter().writeError("print sub sql logview error: " + e.getMessage());
        }
    }
}

