/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output.state;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.statemachine.StateContext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jline.reader.UserInterruptException;

public class InstanceStateContext
implements StateContext {
    public static final long STATUS_QUERY_INTERVAL = TimeUnit.SECONDS.toMillis(5L);
    private Instance instance;
    private List<Instance.StageProgress> taskProgress;
    private Instance.TaskSummary summary;
    private Iterator<String> result;
    private Odps odps;
    private ExecutionContext context;
    private List<Task> tasks;
    private boolean isTerminate = false;
    private boolean isReportFinish = false;
    private Instance.TaskStatus taskStatus;
    private int repositionLines = 0;
    private long startTime;
    private final byte[] lock = new byte[0];

    public InstanceStateContext(Odps odps, Instance instance, ExecutionContext context) throws OdpsException {
        this.odps = odps;
        this.instance = instance;
        this.tasks = instance.getTasks();
        this.context = context;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public Odps getOdps() {
        return this.odps;
    }

    public List<Instance.StageProgress> getTaskProgress() {
        return this.taskProgress;
    }

    public void setTaskProgress(List<Instance.StageProgress> taskProgress) {
        this.taskProgress = taskProgress;
    }

    public Instance.TaskSummary getSummary() {
        return this.summary;
    }

    public void setSummary(Instance.TaskSummary summary) {
        this.summary = summary;
    }

    public Iterator<String> getResult() {
        return this.result;
    }

    public void setResult(Iterator<String> result) {
        this.result = result;
    }

    public String getRunningTaskName() {
        String runningTaskName = null;
        if (this.tasks != null && this.tasks.size() == 1) {
            runningTaskName = this.tasks.get(0).getName();
        } else {
            try {
                Map taskStatuses = this.instance.getTaskStatus();
                for (String name : taskStatuses.keySet()) {
                    if (!Instance.TaskStatus.Status.RUNNING.equals((Object)((Instance.TaskStatus)taskStatuses.get(name)).getStatus())) continue;
                    runningTaskName = name;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return runningTaskName;
    }

    public void setProgressReportFinish(boolean isFinished) {
        this.isReportFinish = isFinished;
    }

    public boolean isProgressReportFinish() {
        return this.isReportFinish;
    }

    public Instance.TaskStatus getTaskStatus() throws OdpsException {
        if (this.taskStatus == null) {
            Map taskStatuses = this.getInstance().getTaskStatus();
            String cTaskName = null;
            for (String taskName : taskStatuses.keySet()) {
                Instance.TaskStatus tStatus = (Instance.TaskStatus)taskStatuses.get(taskName);
                if (Instance.TaskStatus.Status.FAILED.equals((Object)tStatus.getStatus())) {
                    cTaskName = taskName;
                    continue;
                }
                if (!Instance.TaskStatus.Status.RUNNING.equals((Object)tStatus.getStatus())) continue;
                cTaskName = taskName;
            }
            if (cTaskName == null) {
                cTaskName = this.getTasks().get(this.getTasks().size() - 1).getName();
            }
            this.taskStatus = (Instance.TaskStatus)taskStatuses.get(cTaskName);
            if (this.taskStatus == null) {
                throw new OdpsException("task status unknown. taskname=" + cTaskName);
            }
        }
        return this.taskStatus;
    }

    public void setRepositionLines(int lines) {
        this.repositionLines = lines;
    }

    public int getRepositionLines() {
        return this.repositionLines;
    }

    public long getInstanceStartTime() {
        return this.startTime;
    }

    public void setInstanceStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void printLogview() {
        String logviewUrl = ODPSConsoleUtils.generateLogView(this.odps, this.instance, this.context);
        if (!StringUtils.isNullOrEmpty((String)logviewUrl)) {
            this.context.getOutputWriter().writeError("Log view:");
            this.context.getOutputWriter().writeError(logviewUrl);
        }
    }

    public void printInstanceId() {
        this.context.getOutputWriter().writeResult("");
        this.context.getOutputWriter().writeError("ID = " + this.instance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstanceTerminate() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.isTerminate = true;
            try {
                this.lock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceTerminate() {
        this.waitForStatusChecker();
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            boolean terminateFlag = this.isTerminate;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return terminateFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStatusChecker() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (!this.isTerminate) {
                try {
                    this.lock.wait(STATUS_QUERY_INTERVAL);
                }
                catch (InterruptedException e) {
                    throw new UserInterruptException("interrupted while thread sleep");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

