/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output;

import java.io.PrintStream;
import org.fusesource.jansi.Ansi;

public class InPlaceUpdates {
    public static final int MIN_TERMINAL_WIDTH = 94;

    public static boolean isUnixTerminal() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            return false;
        }
        return System.console() != null;
    }

    public static void reprintLine(PrintStream out, String line) {
        out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(line).a('\n').toString());
        out.flush();
    }

    public static int reprintMultiLine(PrintStream out, String line) {
        String[] lines = line.split("\r\n|\r|\n");
        int numLines = lines.length;
        for (String str : lines) {
            out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).a(str).a('\n').toString());
        }
        out.flush();
        return numLines;
    }

    public static void reprintLineWithColorAsBold(PrintStream out, String line, Ansi.Color color) {
        out.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).fg(color).bold().a(line).a('\n').boldOff().reset().toString());
        out.flush();
    }

    public static void rePositionCursor(PrintStream out, int lines) {
        out.print(Ansi.ansi().cursorUp(lines).toString());
        out.flush();
    }

    public static void resetScreen(PrintStream out) {
        out.print(Ansi.ansi().cursor(1, 1).toString());
        out.print(Ansi.ansi().eraseScreen(Ansi.Erase.FORWARD).toString());
        out.flush();
    }

    public static void resetForward(PrintStream out) {
        out.print(Ansi.ansi().eraseScreen(Ansi.Erase.FORWARD).toString());
        out.flush();
    }

    public static void clearScreen(PrintStream out) {
        out.print(Ansi.ansi().eraseScreen(Ansi.Erase.ALL).toString());
        out.print(Ansi.ansi().cursor(1, 1).toString());
        out.flush();
    }
}

