/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.output;

import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.output.CloseProtectedOutputStream;
import java.io.OutputStream;

public class DefaultOutputWriter {
    private final ExecutionContext sessionContext;

    public DefaultOutputWriter(ExecutionContext context) {
        this.sessionContext = context;
    }

    public void writeError(String str) {
        System.err.println(str);
    }

    public void writeIntermediateError(String str) {
        System.err.print(str);
    }

    public void writeErrorFormat(String format, Object ... args) {
        System.err.format(format, args);
    }

    public void writeDebug(String str) {
        if (this.getSessionContext().isDebug()) {
            System.err.println("[DEBUG]:" + str);
        }
    }

    public void writeDebug(Throwable t) {
        if (this.getSessionContext().isDebug()) {
            System.err.print("[DEBUG]: ");
            t.printStackTrace();
        }
    }

    public void writeResult(String str) {
        System.out.println(str);
    }

    public OutputStream getResultStream() {
        return new CloseProtectedOutputStream(System.out);
    }

    public void writeIntermediateResult(String str) {
        System.out.print(str);
    }

    public ExecutionContext getSessionContext() {
        return this.sessionContext;
    }
}

