/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.DirectCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UseSchemaCommand
extends DirectCommand {
    public static final String[] HELP_TAGS = new String[]{"use", "schema"};
    private static final Pattern PATTERN = Pattern.compile("\\s*USE\\s+SCHEMA\\s+(\\w+)\\s*", 2);
    private final String schemaName;

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: use schema <schema name>;");
    }

    public UseSchemaCommand(String commandText, ExecutionContext context, String schemaName) {
        super(commandText, context);
        this.schemaName = schemaName;
    }

    public static SetCommand parse(String commandString, ExecutionContext ctx) throws ODPSConsoleException {
        Matcher matcher = PATTERN.matcher(commandString);
        if (matcher.matches()) {
            String schemaName = matcher.group(1);
            return new SetCommand(true, "odps.default.schema", schemaName, commandString, ctx);
        }
        return null;
    }
}

