/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.task.SqlPlanTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.output.state.InstanceSuccess;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import com.aliyun.openservices.odps.console.utils.tune.ResourceCost;
import com.aliyun.openservices.odps.console.utils.tune.TuningHistory;
import com.aliyun.openservices.odps.console.utils.tune.TuningRecord;
import com.google.common.collect.ImmutableMap;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class TuneCommand
extends MultiClusterCommandBase {
    private static final String PMC_TASK_CONSOLE_KEY = "odps.console.progressive.long.running.task";
    private static final String RESULT_CACHE_ENABLE_KEY = "odps.sql.session.result.cache.enable";
    private static final String TUNE_IGNORE_FAILURE_KEY = "odps.sql.tune.ignore.failure";
    private static final String TUNE_REPORT_FOR_HUMAN = "odps.sql.tune.report.for.human";
    private static final String ONLY_SHOW_BETTER_PLAN = "odps.sql.tune.only.show.better.plan";
    private static final String IS_CURRENT_SETTING = "odps.sql.tune.is.current.setting";
    public static final String[] HELP_TAGS = new String[]{"tune", "tuning"};
    private String taskName = "";
    private boolean isSelect = false;
    private boolean ignoreFailure = false;
    private boolean reportForHuman = true;
    private boolean onlyShowBetterPlan = true;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: TUNE <sql>;");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        if (this.getContext().isInteractiveQuery()) {
            throw new OdpsException("Tune command is not supported in interactive query mode.");
        }
        if ("true".equalsIgnoreCase(SetCommand.setMap.getOrDefault(PMC_TASK_CONSOLE_KEY, "false"))) {
            throw new OdpsException("Tune command is not supported in progressive mode.");
        }
        if ("true".equalsIgnoreCase(SetCommand.setMap.getOrDefault(RESULT_CACHE_ENABLE_KEY, "false"))) {
            throw new OdpsException("Tune command is not supported with result cache.");
        }
        if ("true".equalsIgnoreCase(SetCommand.setMap.getOrDefault(TUNE_IGNORE_FAILURE_KEY, "false"))) {
            this.ignoreFailure = true;
        }
        if ("false".equalsIgnoreCase(SetCommand.setMap.getOrDefault(TUNE_REPORT_FOR_HUMAN, "true"))) {
            this.reportForHuman = false;
        }
        if (!this.reportForHuman || "false".equalsIgnoreCase(SetCommand.setMap.getOrDefault(ONLY_SHOW_BETTER_PLAN, "true"))) {
            this.onlyShowBetterPlan = false;
        }
        if (context.isAsyncMode()) {
            throw new OdpsException("Tune command is not supported in async mode.");
        }
        if (this.isSelect) {
            writer.writeError("Tune command will not report select result to console.");
        }
        String explainTuneSql = "EXPLAIN TUNE " + this.getCommandText();
        TuningRecord explainTuneRecord = new TuningRecord(0, "", null, "", true, true);
        this.runOneSqlTask(explainTuneSql, explainTuneRecord);
        TuningHistory history = TuningHistory.of(explainTuneRecord.result, this.getCommandText());
        if (history.records.isEmpty()) {
            throw new OdpsException("EXPLAIN TUNE cannot get valid query plan, explain query:" + explainTuneSql);
        }
        writer.writeError("RUN " + history.records.size() + " Candidate Plans Begin.");
        for (TuningRecord record : history.records) {
            this.runOneSqlTask(this.getCommandText(), record);
            if (record.endTimestamp == 0L) {
                writer.writeError("RUN Candidate Plan #" + record.planNumber + " Failed.");
                continue;
            }
            writer.writeError("RUN Candidate Plan #" + record.planNumber + " Done.");
        }
        writer.writeResult(history.toTuningReport(this.reportForHuman, this.onlyShowBetterPlan));
        writer.writeError("OK");
    }

    private void runOneSqlTask(String sql, TuningRecord tuningRecord) throws ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        int retryTime = context.getRetryTimes();
        retryTime = retryTime > 0 ? retryTime : 1;
        boolean isDryRun = this.getContext().isDryRun();
        while (retryTime > 0) {
            SQLTask task = null;
            try {
                this.taskName = this.getTaskName(isDryRun);
                if (isDryRun) {
                    task = new SqlPlanTask(this.taskName, sql);
                } else {
                    task = new SQLTask();
                    task.setName(this.taskName);
                    task.setQuery(sql);
                }
                HashMap<String, String> taskConfig = QueryUtil.getTaskConfig();
                if (!this.getContext().isMachineReadable()) {
                    HashMap<String, String> settings = new HashMap<String, String>();
                    settings.put("odps.sql.select.output.format", "HumanReadable");
                    TuneCommand.addSetting(taskConfig, (Map<String, String>)settings);
                }
                TuneCommand.addSetting(taskConfig, SetCommand.setMap);
                if (tuningRecord.hints != null) {
                    TuneCommand.addSetting(taskConfig, tuningRecord.hints);
                    if (!tuningRecord.isExplainTune) {
                        TuneCommand.addSetting(taskConfig, (Map<String, String>)ImmutableMap.of((Object)IS_CURRENT_SETTING, (Object)String.valueOf(tuningRecord.isCurrentSetting)));
                    }
                }
                for (Map.Entry entry : taskConfig.entrySet()) {
                    task.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                this.runJob((Task)task, tuningRecord);
                break;
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (task instanceof SQLTask && QueryUtil.isOperatorDisabled(((SQLTask)task).getQuery())) {
                    String errorMessage = e.getMessage();
                    if (errorMessage.contains("ODPS-0110999")) {
                        throw new ODPSConsoleException(e.getMessage());
                    }
                    if (!errorMessage.contains("ODPS-")) {
                        throw new ODPSConsoleException("ODPS-0110999:" + e.getMessage());
                    }
                }
                if (--retryTime == 0) {
                    if (tuningRecord.isExplainTune || !this.ignoreFailure) {
                        throw new ODPSConsoleException(e.getMessage(), e);
                    }
                    tuningRecord.endTimestamp = 0L;
                    return;
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJob(Task task, TuningRecord record) throws OdpsException, ODPSConsoleException {
        record.taskName = this.taskName;
        ExecutionContext context = this.getContext();
        record.beginTimestamp = System.currentTimeMillis();
        InstanceRunner runner = new InstanceRunner(this.getCurrentOdps(), task, context);
        runner.submit();
        OdpsHooks hooks = runner.getInstance().getOdpsHooks();
        runner.getInstance().setOdpsHooks(null);
        runner.waitForCompletion();
        this.instanceId = runner.getInstance().getId();
        StringBuilder builder = new StringBuilder();
        try {
            Iterator<String> queryResult = runner.getResult();
            while (queryResult.hasNext()) {
                ODPSConsoleUtils.checkThreadInterrupted();
                builder.append(queryResult.next()).append("\n");
            }
            Instance instance = runner.getInstance();
            record.instanceId = this.instanceId;
            record.result = builder.toString();
            record.endTimestamp = System.currentTimeMillis();
            try {
                record.resourceCost = ResourceCost.fromText(InstanceSuccess.getTaskSummaryV1(instance.getOdps(), instance, this.taskName, context.getOutputWriter()).getSummaryText());
            }
            catch (Exception e) {
                record.resourceCost = ResourceCost.makeUnknownCost("Unknown cost, get task summary failed.");
            }
            record.logviewUrl = runner.getInstanceStateContext().getOdps().logview().generateLogView(instance, (long)context.getLogViewLife());
        }
        finally {
            if (hooks != null) {
                hooks.after(runner.getInstance(), this.getCurrentOdps());
            }
        }
    }

    protected String getTaskName(boolean isDryRun) {
        if (isDryRun) {
            return "console_sqlplan_task_" + Calendar.getInstance().getTimeInMillis();
        }
        return "console_query_task_" + Calendar.getInstance().getTimeInMillis();
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public TuneCommand(String command, ExecutionContext context) {
        super(command, context);
        if (command.toUpperCase().matches("^SELECT[\\s\\S]*")) {
            this.isSelect = true;
        }
    }

    public static TuneCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String regStr = "^\\s*(TUNE)(\\s+)([\\s\\S]*)";
        Pattern p = Pattern.compile(regStr, 2);
        Matcher m = p.matcher(commandString);
        if (m.find()) {
            String sqlPart = m.group(3).trim();
            if (sqlPart.isEmpty()) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. TUNE <sql>;");
            }
            if (!(sqlPart = sqlPart.trim()).endsWith(";")) {
                sqlPart = sqlPart + ";";
            }
            return new TuneCommand(sqlPart, sessionContext);
        }
        return null;
    }
}

