/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class MergeCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"merge", "table", "alter", "smallfile", "smallfiles"};
    private static final String MERGE_CROSSPATH_FLAG = "odps.merge.cross.paths";
    private String taskName = "";

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: alter table <table name> (<partition spec>)? merge smallfiles");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        DefaultOutputWriter writer = context.getOutputWriter();
        int retryTime = context.getRetryTimes();
        int n = retryTime = retryTime > 0 ? retryTime : 1;
        while (retryTime > 0) {
            MergeTask task = null;
            try {
                this.taskName = "console_merge_task_" + Calendar.getInstance().getTimeInMillis();
                task = new MergeTask(this.taskName, this.getCommandText());
                HashMap<String, String> taskConfig = QueryUtil.getTaskConfig();
                if (!SetCommand.setMap.containsKey(MERGE_CROSSPATH_FLAG)) {
                    HashMap<String, String> settings = new HashMap<String, String>();
                    settings.put(MERGE_CROSSPATH_FLAG, "true");
                    MergeCommand.addSetting(taskConfig, settings);
                }
                for (Map.Entry<String, String> property : taskConfig.entrySet()) {
                    task.setProperty(property.getKey(), property.getValue());
                }
                this.runJob((Task)task);
                break;
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (--retryTime == 0) {
                    throw new ODPSConsoleException(e.getMessage());
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
            }
        }
        writer.writeError("OK");
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public MergeCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public static MergeCommand parse(String commandString, ExecutionContext sessionContext) {
        String regex = "\\s*ALTER\\s+TABLE\\s+(.*)\\s+(MERGE\\s+SMALLFILES\\s*)$";
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(commandString);
        if (m.find()) {
            return new MergeCommand(m.group(1), sessionContext);
        }
        return null;
    }
}

