/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.History;

public class HistoryCommand
extends AbstractCommand {
    private String filter;
    public static final String[] HELP_TAGS = new String[]{"history"};

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: history [*grep <string>]");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        Pattern pattern;
        if (ODPSConsoleUtils.isWindows()) {
            this.getContext().getOutputWriter().writeError("Not supported on Windows");
            return;
        }
        String colorStart = "\u001b[31;1m";
        String colorEnd = "\u001b[0m";
        History history = ODPSConsoleUtils.getOdpsConsoleReader().getHistory();
        Pattern pattern2 = pattern = this.filter != null ? Pattern.compile(this.filter) : null;
        if (history != null) {
            for (History.Entry entry : history) {
                String line = entry.line();
                if (pattern != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    StringBuffer sb = new StringBuffer();
                    do {
                        matcher.appendReplacement(sb, colorStart + matcher.group() + colorEnd);
                    } while (matcher.find());
                    matcher.appendTail(sb);
                    line = sb.toString();
                }
                this.getContext().getOutputWriter().writeError(String.valueOf(entry.index()) + ' ' + line);
            }
        }
    }

    public HistoryCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
        String[] split = commandText.split("grep ", 2);
        if (split.length > 1) {
            this.filter = split[1].trim().replaceAll("^\"|\"$", "");
        }
    }

    public static HistoryCommand parse(String cmd, ExecutionContext cxt) {
        if (cmd == null || cxt == null || ODPSConsoleUtils.isWindows()) {
            return null;
        }
        if ("history".equalsIgnoreCase(cmd.trim().split(" ")[0])) {
            return new HistoryCommand(cmd.trim(), cxt);
        }
        return null;
    }
}

