/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.google.gson.JsonObject;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ExternalProjectCommand
extends AbstractCommand {
    private static final String SOURCE_OPTION = "source";
    private static final String NAME_OPTION = "name";
    private static final String COMMENT_OPTION = "comment";
    private static final String REF_OPTION = "ref";
    private static final String NAMENODE_OPTION = "nn";
    private static final String HMS_OPTION = "hms";
    private static final String DATABASE_OPTION = "db";
    private static final String VPC_OPTION = "vpc";
    private static final String REGION_OPTION = "region";
    private static final String ACCESS_IP_OPTION = "accessIp";
    private static final String DFS_NS_OPTION = "dfsNamespace";
    private static final String PROPERTIES_OPTION = "D";
    private static final String ROLE_ARN_OPTION = "ramRoleArn";
    private static final String ENDPOINT_OPTION = "endpoint";
    private static final String OSS_ENDPOINT_OPTION = "ossEndpoint";
    private static final String TABLE_PROPERTIES_OPTION = "T";
    private static final String HMS_PRINCIPALS = "hmsPrincipals";
    private static final String FOREIGNSERVER_OPTION = "foreignServer";
    private static final String CREATE_ACTION = "create";
    private static final String UPDATE_ACTION = "update";
    private static final String DELETE_ACTION = "delete";
    private static final String DROP_ACTION = "drop";
    private static final Pattern PATTERN = Pattern.compile("\\s*(create|update|drop|delete)\\s+EXTERNALPROJECT\\s+(.+)", 34);
    private final Action action;
    public static final String[] HELP_TAGS = new String[]{"create", "externalproject", "external", "project"};

    private ExternalProjectCommand(Action action, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.action = action;
    }

    @Override
    protected void run() throws OdpsException, ODPSConsoleException {
        this.action.run(this.getCurrentOdps());
    }

    public Action getAction() {
        return this.action;
    }

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: create externalproject -name <project name> -ref <referred managed project>  [-comment <comment>]");
        stream.println("                              [-nn <namenode ips> -hms <hive metastore ips>]|[-foreignServer <server_name>] -db <hive database name> [-hmsPrincipals <kerberos principals of hms>]");
        stream.println("                              [-vpc <vpc id> -region <vpc region> [-accessIp <vpc internal ips>]] [-dfsNamespace <hive ha dfs namespace>]");
        stream.println("                              [-D <property name 1>=<value1> ...];");
        stream.println("Usage: create externalproject -source dlf -name <project name> -ref <referred managed project>  [-comment <comment>]");
        stream.println("                              -region <dlf region> -db <dlf database name> -endpoint <dlf endpoint> [-ramRoleArn <ram role arn to access dlf>]");
        stream.println("                              [-D <property name 1>=<value1> ...];");
        stream.println("Usage: update externalproject -name <project name>");
        stream.println("                              -nn <namenode ips> -hms <hive metastore ips> -db <hive database name> [-hmsPrincipals <kerberos principals of hms>]");
        stream.println("                              [-vpc <vpc id> -region <vpc region> [-accessIp <vpc internal ips>]] [-dfsNamespace <hive ha dfs namespace>]");
        stream.println("                              [-D <property name 1>=<value1> ...];");
        stream.println("Usage: update externalproject -source dlf -name <project name>");
        stream.println("                              -region <dlf region> -db <dlf database name> -endpoint <dlf endpoint> [-ramRoleArn <ram role arn to access dlf>]");
        stream.println("                              [-ossEndpoint <oss endpoint>]");
        stream.println("                              [-T <table property name 1>=<value1> ...] [-D <property name 1>=<value1> ...];");
        stream.println("Usage: drop externalproject -name <project name>");
        stream.println();
        stream.println("1. All ip addresses require ports specified: 'ip:port'. Multiple ip addresses should be delimited by comma.");
        stream.println("2. To see all supported table properties you can set via '-T p=v', refer to external project documentation.");
        stream.println("3. To see how to specify 'hmsPrincipals' and 'dfs.data.transfer.protection' for kerberos hive, refer to external project documentation.");
        stream.println();
        stream.println("## Examples:");
        stream.println("#### hive db:");
        stream.println("  create externalproject -name p1 -ref myprj1 -comment test -nn \"1.1.1.1:8080,2.2.2.2:3823\" -hms \"3.3.3.3:3838\" -db default;");
        stream.println("  create externalproject -name p1 -ref myprj1 -comment test -nn \"1.1.1.1:8080,2.2.2.2:3823\" -hms \"3.3.3.3:3838\" -db default ");
        stream.println("                         -vpc vpc1 -region cn-zhangjiakou -accessIp \"192.168.0.11-192.168.0.14:50010,192.168.0.23:50020\"");
        stream.println("                         -dfsNamespace emr-cluster;");
        stream.println("  create externalproject -name p1 -ref myprj1 -comment test -nn \"1.1.1.1:8080,2.2.2.2:3823\" -hms \"3.3.3.3:3838\" -db default ");
        stream.println("                         -vpc vpc1 -region cn-zhangjiakou -accessIp \"192.168.0.11-192.168.0.14:50010,192.168.0.23:50020\"");
        stream.println("                         -dfsNamespace emr-cluster -D odps.properties.rolearn=samplerolearn -D another.property=abcde;");
        stream.println("  create externalproject -name p1 -ref myprj1 -comment test -foreignServer server_1 -db default;");
        stream.println("#### hive db with kerberos:");
        stream.println("  create externalproject -name p1 -ref myprj1 -comment test -nn \"1.1.1.1:8080,2.2.2.2:3823\" -hms \"3.3.3.3:3838,4.4.4.4:3838\" -db default ");
        stream.println("                         -hmsPrincipals \"hive/emr-header-1.cluster-203713@EMR.203713.COM,hive/emr-header-2.cluster-203713@EMR.203713.COM\"");
        stream.println("                         -vpc vpc1 -region cn-zhangjiakou -accessIp \"192.168.0.11-192.168.0.14:50010,192.168.0.23:50020\"");
        stream.println("                         -dfsNamespace emr-cluster -D dfs.data.transfer.protection=integrity;");
        stream.println("#### dlf:");
        stream.println("  create externalproject -source dlf -name p1 -ref myprj1 -comment test -region cn-shanghai -db default ");
        stream.println("                         -endpoint \"dlf.cn-shanghai.aliyuncs.com\";");
        stream.println("  create externalproject -source dlf -name p1 -ref myprj1 -comment test -region cn-shanghai -db default ");
        stream.println("                         -endpoint \"dlf.cn-shanghai.aliyuncs.com\" -ramRoleArn \"acs:ram::12345:role/myrolefordlfonodps\";");
        stream.println("  create externalproject -source dlf -name p1 -ref myprj1 -comment test -region cn-shanghai -db default ");
        stream.println("                         -endpoint \"dlf.cn-shanghai.aliyuncs.com\" -D a.property=ddfjie -D another.property=abcde;");
        stream.println("  create externalproject -source dlf -name p1 -ref myprj1 -comment test -region cn-shanghai -db default ");
        stream.println("                         -endpoint \"dlf.cn-shanghai.aliyuncs.com\" -ossEndpoint \"oss-cn-shanghai-internal.aliyuncs.com\" ");
        stream.println("                         -T file_format=orc -T output_format=text -D another.property=abcde;");
    }

    public static AbstractCommand parse(String cmd, ExecutionContext sessionContext) throws ODPSConsoleException {
        Matcher m = PATTERN.matcher(cmd);
        boolean match = m.matches();
        if (!match) {
            return null;
        }
        String actionName = m.group(1);
        String input = m.group(2);
        String[] inputs = ODPSConsoleUtils.translateCommandline(input);
        Options options = new Options();
        options.addOption(Option.builder((String)NAME_OPTION).hasArg().required().desc("Project name.").build());
        options.addOption(SOURCE_OPTION, true, "External project source - supported sources: hive,dlf. Default: hive.");
        options.addOption(COMMENT_OPTION, true, "Project description.");
        options.addOption(REF_OPTION, true, "Managed Project refs to.");
        options.addOption(FOREIGNSERVER_OPTION, true, "Using foreign server name.");
        options.addOption(NAMENODE_OPTION, true, "Hadoop namenode ip and ports.");
        options.addOption(HMS_OPTION, true, "Hive metastore ip and ports.");
        options.addOption(DATABASE_OPTION, true, "Database name to map external project to.");
        options.addOption(VPC_OPTION, true, "Vpc id");
        options.addOption(REGION_OPTION, true, "Region.");
        options.addOption(ACCESS_IP_OPTION, true, "Additional vpc ip need to be accessed");
        options.addOption(DFS_NS_OPTION, true, "Hive DFS nameservice.");
        options.addOption(ROLE_ARN_OPTION, true, "Ram role arn.");
        options.addOption(ENDPOINT_OPTION, true, "Endpoint of external source.");
        options.addOption(OSS_ENDPOINT_OPTION, true, "Endpoint of oss - for dlf source which use oss as storage.");
        options.addOption(HMS_PRINCIPALS, true, "Comma separated kerberos principals corresponding to host specified in 'hms'.");
        Option pOption = new Option(PROPERTIES_OPTION, true, "Additional parameters, like '-D p1=v1 -D p2=v2.");
        pOption.setValueSeparator('=');
        pOption.setArgs(2);
        options.addOption(pOption);
        Option tOption = new Option(TABLE_PROPERTIES_OPTION, true, "Additional table parameters, like '-T p1=v1 -T p2=v2.");
        tOption.setValueSeparator('=');
        tOption.setArgs(2);
        options.addOption(tOption);
        try {
            Action action;
            DefaultParser parser = new DefaultParser();
            CommandLine params = parser.parse(options, inputs, false);
            String source = params.getOptionValue(SOURCE_OPTION, "hive");
            if (source.equals("hive")) {
                action = new HiveSourceAction(actionName, params);
            } else if (source.equals("dlf")) {
                action = new DlfSourceAction(actionName, params);
            } else if (source.equals("maxcompute")) {
                action = new OdpsSourceAction(actionName, params);
            } else {
                throw new UnsupportedOperationException("Unknown source: " + source);
            }
            return new ExternalProjectCommand(action, cmd, sessionContext);
        }
        catch (ParseException e) {
            throw new ODPSConsoleException("Error parsing command", e);
        }
    }

    public static class OdpsSourceAction
    extends Action {
        private final String serverName;
        private final String databaseName;

        OdpsSourceAction(String action, CommandLine params) {
            super(action, params);
            this.serverName = params.getOptionValue(ExternalProjectCommand.FOREIGNSERVER_OPTION);
            this.databaseName = params.getOptionValue(ExternalProjectCommand.DATABASE_OPTION);
            this.validateParams();
        }

        @Override
        protected Project.ExternalProjectProperties buildExternalProjectProperties() {
            Project.ExternalProjectProperties extProps = new Project.ExternalProjectProperties("maxcompute");
            extProps.addProperty("maxcompute.database.name", this.databaseName);
            extProps.addNetworkProperty("odps.external.net.vpc", "false");
            if (this.serverName != null) {
                extProps.addProperty("foreign.server.name", this.serverName);
            }
            return extProps;
        }

        private void validateParams() {
            if (this.getActionName().equals(ExternalProjectCommand.DELETE_ACTION) || this.getActionName().equals(ExternalProjectCommand.DROP_ACTION)) {
                return;
            }
            OdpsSourceAction.require(ExternalProjectCommand.FOREIGNSERVER_OPTION, this.serverName);
            OdpsSourceAction.require(ExternalProjectCommand.DATABASE_OPTION, this.databaseName);
        }
    }

    public static class DlfSourceAction
    extends Action {
        private final String region;
        private final String endpoint;
        private final String databaseName;
        private final String roleArn;
        private final String ossEndpoint;
        private Properties tableProperties = new Properties();

        DlfSourceAction(String action, CommandLine params) {
            super(action, params);
            this.region = params.getOptionValue(ExternalProjectCommand.REGION_OPTION);
            this.endpoint = params.getOptionValue(ExternalProjectCommand.ENDPOINT_OPTION);
            this.databaseName = params.getOptionValue(ExternalProjectCommand.DATABASE_OPTION);
            this.roleArn = params.getOptionValue(ExternalProjectCommand.ROLE_ARN_OPTION);
            this.ossEndpoint = params.getOptionValue(ExternalProjectCommand.OSS_ENDPOINT_OPTION);
            if (params.hasOption(ExternalProjectCommand.TABLE_PROPERTIES_OPTION)) {
                this.tableProperties = params.getOptionProperties(ExternalProjectCommand.TABLE_PROPERTIES_OPTION);
            }
            this.validateParams();
        }

        @Override
        protected Project.ExternalProjectProperties buildExternalProjectProperties() {
            Project.ExternalProjectProperties extProps = new Project.ExternalProjectProperties("dlf");
            extProps.addProperty("dlf.region", this.region);
            extProps.addProperty("dlf.endpoint", this.endpoint);
            extProps.addProperty("dlf.database.name", this.databaseName);
            extProps.addProperty("dlf.rolearn", this.roleArn);
            if (this.ossEndpoint != null) {
                extProps.addProperty("oss.endpoint", this.ossEndpoint);
            }
            if (!this.tableProperties.isEmpty()) {
                JsonObject obj = new JsonObject();
                for (String name : this.tableProperties.stringPropertyNames()) {
                    String value = this.tableProperties.getProperty(name).replaceAll("^[\"']|[\"']$", "");
                    obj.addProperty(name, value);
                }
                extProps.addProperty("table_properties", obj);
            }
            return extProps;
        }

        private void validateParams() {
            if (this.getActionName().equals(ExternalProjectCommand.DELETE_ACTION) || this.getActionName().equals(ExternalProjectCommand.DROP_ACTION)) {
                return;
            }
            DlfSourceAction.require(ExternalProjectCommand.REGION_OPTION, this.region);
            DlfSourceAction.require(ExternalProjectCommand.ENDPOINT_OPTION, this.endpoint);
            DlfSourceAction.require(ExternalProjectCommand.DATABASE_OPTION, this.databaseName);
        }
    }

    public static class HiveSourceAction
    extends Action {
        private final String nameNodes;
        private final String hiveMetastores;
        private final String databaseName;
        private final String vpcId;
        private final String vpcRegion;
        private final String accessIp;
        private final String dfsNamespace;
        private final String hmsPrincipals;
        private final String serverName;

        HiveSourceAction(String action, CommandLine params) {
            super(action, params);
            this.nameNodes = params.getOptionValue(ExternalProjectCommand.NAMENODE_OPTION);
            this.hiveMetastores = params.getOptionValue(ExternalProjectCommand.HMS_OPTION);
            this.databaseName = params.getOptionValue(ExternalProjectCommand.DATABASE_OPTION);
            this.vpcId = params.getOptionValue(ExternalProjectCommand.VPC_OPTION);
            this.vpcRegion = params.getOptionValue(ExternalProjectCommand.REGION_OPTION);
            this.accessIp = params.hasOption(ExternalProjectCommand.ACCESS_IP_OPTION) ? params.getOptionValue(ExternalProjectCommand.ACCESS_IP_OPTION) : params.getOptionValue(ExternalProjectCommand.NAMENODE_OPTION);
            this.dfsNamespace = params.getOptionValue(ExternalProjectCommand.DFS_NS_OPTION);
            this.hmsPrincipals = params.getOptionValue(ExternalProjectCommand.HMS_PRINCIPALS);
            this.serverName = params.getOptionValue(ExternalProjectCommand.FOREIGNSERVER_OPTION);
            this.validateParams();
        }

        @Override
        protected Project.ExternalProjectProperties buildExternalProjectProperties() {
            Project.ExternalProjectProperties extProps = new Project.ExternalProjectProperties("hive");
            extProps.addProperty("hive.database.name", this.databaseName);
            if (this.serverName != null) {
                extProps.addProperty("foreign.server.name", this.serverName);
            } else {
                extProps.addProperty("hms.ips", this.hiveMetastores);
                extProps.addProperty("hdfs.namenode.ips", this.nameNodes);
            }
            if (this.vpcId != null) {
                extProps.addNetworkProperty("odps.external.net.vpc", "true");
                extProps.addNetworkProperty("odps.vpc.id", this.vpcId);
                extProps.addNetworkProperty("odps.vpc.region", this.vpcRegion);
                extProps.addNetworkProperty("odps.vpc.access.ips", this.accessIp);
            } else {
                extProps.addNetworkProperty("odps.external.net.vpc", "false");
            }
            if (this.dfsNamespace != null) {
                extProps.addNetworkProperty("dfs.nameservices", this.dfsNamespace);
            }
            if (this.hmsPrincipals != null) {
                extProps.addProperty("hms.principals", this.hmsPrincipals);
            }
            return extProps;
        }

        private void validateParams() {
            if (this.getActionName().equals(ExternalProjectCommand.DELETE_ACTION) || this.getActionName().equals(ExternalProjectCommand.DROP_ACTION)) {
                return;
            }
            HiveSourceAction.require(ExternalProjectCommand.DATABASE_OPTION, this.databaseName);
            if (this.serverName != null) {
                return;
            }
            HiveSourceAction.require(ExternalProjectCommand.NAMENODE_OPTION, this.nameNodes);
            HiveSourceAction.require(ExternalProjectCommand.HMS_OPTION, this.hiveMetastores);
            if (this.vpcId != null) {
                HiveSourceAction.require(ExternalProjectCommand.VPC_OPTION, this.vpcId);
                HiveSourceAction.require(ExternalProjectCommand.REGION_OPTION, this.vpcRegion);
                HiveSourceAction.require(ExternalProjectCommand.ACCESS_IP_OPTION, this.accessIp);
            }
        }
    }

    public static abstract class Action {
        private final String actionName;
        private final String projectName;
        private final String comment;
        private String refProjectName;
        private Properties properties = new Properties();
        private static final Set<String> validActions = new HashSet<String>(Arrays.asList("create", "update", "drop", "delete"));

        Action(String action, CommandLine params) {
            this.actionName = action.toLowerCase();
            this.projectName = params.getOptionValue(ExternalProjectCommand.NAME_OPTION);
            this.comment = params.getOptionValue(ExternalProjectCommand.COMMENT_OPTION);
            this.refProjectName = params.getOptionValue(ExternalProjectCommand.REF_OPTION);
            if (params.hasOption(ExternalProjectCommand.PROPERTIES_OPTION)) {
                this.properties = params.getOptionProperties(ExternalProjectCommand.PROPERTIES_OPTION);
            }
            this.validateParams();
        }

        protected abstract Project.ExternalProjectProperties buildExternalProjectProperties();

        public Project.ExternalProjectProperties finalExternalProjectProperties() {
            Project.ExternalProjectProperties extProps = this.buildExternalProjectProperties();
            for (String name : this.properties.stringPropertyNames()) {
                String value = this.properties.getProperty(name).replaceAll("^[\"']|[\"']$", "");
                extProps.addNetworkProperty(name, value);
            }
            return extProps;
        }

        void run(Odps odps) throws OdpsException {
            switch (this.actionName) {
                case "create": {
                    if (StringUtils.isNullOrEmpty((String)this.refProjectName)) {
                        this.refProjectName = odps.getDefaultProject();
                    }
                    odps.projects().createExternalProject(this.projectName, this.comment, this.refProjectName, this.finalExternalProjectProperties());
                    break;
                }
                case "update": {
                    Project.ExternalProjectProperties extProps = this.finalExternalProjectProperties();
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("external_project_properties", extProps.toJson());
                    odps.projects().updateProject(this.projectName, props);
                    break;
                }
                case "drop": 
                case "delete": {
                    odps.projects().deleteExternalProject(this.projectName);
                }
            }
        }

        public final String getActionName() {
            return this.actionName;
        }

        private void validateParams() {
            if (!validActions.contains(this.actionName)) {
                throw new IllegalArgumentException("Unknown action: " + this.actionName);
            }
            Action.require(ExternalProjectCommand.NAME_OPTION, this.projectName);
            if (this.actionName.equals(ExternalProjectCommand.DELETE_ACTION) || this.actionName.equals(ExternalProjectCommand.DROP_ACTION)) {
                return;
            }
        }

        protected static void require(String name, String value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException(name + " is required and not allowed to be empty.");
            }
        }
    }
}

