/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.CompositeCommand;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.SessionUtils;
import java.util.LinkedList;
import java.util.List;

public class ExecuteCommand
extends AbstractCommand {
    public ExecuteCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        if (this.getContext().getAutoSessionMode()) {
            SessionUtils.autoAttachSession(this.getContext(), this.getCurrentOdps());
        }
        AbstractCommand command = CommandParserUtils.parseCommand(this.getCommandText(), this.getContext());
        LinkedList<AbstractCommand> odpsCommandList = new LinkedList<AbstractCommand>();
        odpsCommandList.add(command);
        command = new CompositeCommand(odpsCommandList, "", this.getContext());
        command.run();
    }

    public static AbstractCommand parse(List<String> optionList, ExecutionContext sessionContext) throws ODPSConsoleException {
        String option = "-e";
        if (optionList.contains(option) && optionList.indexOf(option) + 1 < optionList.size()) {
            int index = optionList.indexOf(option);
            String arg = optionList.get(index + 1);
            optionList.remove(optionList.indexOf(option));
            optionList.remove(optionList.indexOf(arg));
            if (!arg.endsWith(";")) {
                arg = arg + ";";
            }
            return new ExecuteCommand(arg, sessionContext);
        }
        return null;
    }
}

