/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.commands;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.MergeTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.utils.CommandParserUtils;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class CompactCommand
extends MultiClusterCommandBase {
    public static final String[] HELP_TAGS = new String[]{"merge", "table", "alter", "compact"};
    private String compactType;
    private Map<String, String> params;
    private static final String MAJOR_COMPACT = "major_compact";
    private static final String MINOR_COMPACT = "minor_compact";
    private String taskName = "";

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: alter table <table_name> [partition (partition_key = 'partition_value' [, ...])] compact [major|minor] [-h recentHoursThresholdForPartialCompact (int type, only minor compact takes effect)] [-f forceMode (When the compact time is less than the retention time, the compact time is automatically corrected to the table's retention time. When this is set, cancels this behavior)]");
    }

    @Override
    public void run() throws OdpsException, ODPSConsoleException {
        int retryTime;
        ExecutionContext context = this.getContext();
        String tablePart = this.getCommandText();
        if (tablePart.toLowerCase().contains("partition")) {
            tablePart = tablePart.trim().split("\\s+")[0];
        }
        Coordinate coordinate = Coordinate.getCoordinateABC(tablePart);
        coordinate.interpretByCtx(context);
        DefaultOutputWriter writer = context.getOutputWriter();
        String projectName = coordinate.getProjectName();
        String schemaName = coordinate.getSchemaName();
        String tableName = coordinate.getObjectName();
        Table table = this.getCurrentOdps().tables().get(projectName, schemaName, tableName);
        if (!table.isTransactional()) {
            throw new OdpsException(tablePart + " is not a transactional table.");
        }
        int recentHours = -1;
        if (MINOR_COMPACT.equals(this.compactType) && this.params.containsKey("h")) {
            try {
                recentHours = Integer.parseInt(this.params.get("h"));
                int acidDataRetainHours = table.getAcidDataRetainHours();
                if (recentHours < acidDataRetainHours && !this.params.containsKey("f")) {
                    writer.writeError("Warning: setting 'recentHoursThresholdForPartialCompact' below the data retention period (" + acidDataRetainHours + " hours) prevents past time travel. It's now set to match the retention period. Use -f to override.");
                    recentHours = acidDataRetainHours;
                }
            }
            catch (NumberFormatException e) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. recentHoursThresholdForPartialCompact should be Integer.");
            }
        }
        int n = retryTime = (retryTime = context.getRetryTimes()) > 0 ? retryTime : 1;
        while (retryTime > 0) {
            MergeTask task = null;
            try {
                this.taskName = "console_merge_task_" + Calendar.getInstance().getTimeInMillis();
                task = new MergeTask(this.taskName, this.getCommandText());
                HashMap<String, String> taskConfig = QueryUtil.getTaskConfig();
                HashMap<String, String> settings = new HashMap<String, String>();
                settings.put("odps.merge.txn.table.compact", this.compactType);
                settings.put("odps.merge.restructure.action", "hardlink");
                if (MINOR_COMPACT.equals(this.compactType)) {
                    settings.put("odps.merge.txn.table.compact.txn.id", String.valueOf(recentHours));
                }
                CompactCommand.addSetting(taskConfig, settings);
                for (Map.Entry<String, String> property : taskConfig.entrySet()) {
                    task.setProperty(property.getKey(), property.getValue());
                }
                this.runJob((Task)task);
                break;
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (--retryTime == 0) {
                    throw new ODPSConsoleException(e.getMessage());
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
            }
        }
        writer.writeError("OK");
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public CompactCommand(String command, String compactType, Map<String, String> params, ExecutionContext context) {
        super(command, context);
        this.params = params;
        this.compactType = compactType;
    }

    private static String getCompactType(String type) {
        if (StringUtils.isNullOrEmpty((String)type)) {
            return null;
        }
        if (type.equalsIgnoreCase("major")) {
            return MAJOR_COMPACT;
        }
        if (type.equalsIgnoreCase("minor")) {
            return MINOR_COMPACT;
        }
        return null;
    }

    public static CompactCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        String regstr = "(?s)\\s*ALTER\\s+TABLE\\s+(.*)\\s+COMPACT\\s+(.*)";
        Pattern p = Pattern.compile(regstr, 2);
        Matcher m = p.matcher(commandString);
        if (m.find()) {
            String tablePart = m.group(1).trim();
            String[] params = m.group(2).trim().split("\\s+");
            String compactType = CompactCommand.getCompactType(params[0]);
            if (compactType == null) {
                throw new ODPSConsoleException("Bad Command, Type \"help;\"(--help) or \"h;\"(-h) for help. Compact type should be MAJOR or MINOR.");
            }
            return new CompactCommand(tablePart, compactType, CommandParserUtils.parseArguments(commandString), sessionContext);
        }
        return null;
    }
}

