/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityConfiguration;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import java.io.PrintStream;

public class ShowSecurityConfigurationCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"show", "security", "configuration", "auth"};

    public static void printUsage(PrintStream out) {
        out.println("Usage: show securityconfiguration");
    }

    public ShowSecurityConfigurationCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        SecurityConfiguration securityConfig = sm.getSecurityConfiguration();
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        outputWriter.writeResult("CheckPermissionUsingAcl=" + securityConfig.checkPermissionUsingAcl());
        outputWriter.writeResult("CheckPermissionUsingPolicy=" + securityConfig.checkPermissionUsingPolicy());
        outputWriter.writeResult("ObjectCreatorHasAccessPermission=" + securityConfig.objectCreatorHasAccessPermission());
        outputWriter.writeResult("ObjectCreatorHasGrantPermission=" + securityConfig.objectCreatorHasGrantPermission());
        outputWriter.writeResult("LabelSecurity=" + securityConfig.labelSecurity());
        outputWriter.writeResult("ProjectProtection=" + securityConfig.projectProtection());
        try {
            if (securityConfig.getProjectProtectionExceptionPolicy() != null && !"".equals(securityConfig.getProjectProtectionExceptionPolicy())) {
                outputWriter.writeResult("ProjectProtection with Exception:" + securityConfig.getProjectProtectionExceptionPolicy());
            }
        }
        catch (OdpsException odpsException) {
            // empty catch block
        }
        outputWriter.writeResult("ExternalResourceAccessControl=" + securityConfig.externalResourceAccessControl());
        if (securityConfig.externalResourceAccessControl()) {
            outputWriter.writeResult("ExternalResourceLocations: " + securityConfig.getExternalResourceLocations());
        }
        if (!StringUtils.isNullOrEmpty((String)securityConfig.getAuthorizationVersion())) {
            outputWriter.writeResult("AuthorizationVersion=" + securityConfig.getAuthorizationVersion());
        }
        if (!StringUtils.isNullOrEmpty((String)securityConfig.getGrammarVersion())) {
            outputWriter.writeResult("GrammarVersion=" + securityConfig.getGrammarVersion());
        }
        outputWriter.writeResult("EnableDownloadPrivilege=" + securityConfig.checkDownloadPrivilege());
    }

    public static ShowSecurityConfigurationCommand parse(String commandString, ExecutionContext context) {
        if (commandString.toUpperCase().matches("\\s*SHOW\\s+SECURITYCONFIGURATION\\s*")) {
            return new ShowSecurityConfigurationCommand(commandString, context);
        }
        return null;
    }
}

