/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.auth;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.commands.SetCommand;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jline.reader.UserInterruptException;

public class AuthorizationCommand
extends AbstractCommand {
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("\\s*GRANT.*"), Pattern.compile("\\s*REVOKE.*"), Pattern.compile("\\s*SHOW\\s+(GRANTS|ACL|PACKAGE|LABEL|ROLE|PRINCIPALS|PRIV).*"), Pattern.compile("\\s*CLEAR\\s+EXPIRED\\s+GRANTS\\s*"), Pattern.compile("\\s*LIST\\s+(USERS|ROLES|TRUSTEDPROJECTS|ACCOUNTPROVIDERS|GROUPS|TENANT USERS|TENANT ROLES)\\s*"), Pattern.compile("\\s*CREATE\\s+(ROLE|PACKAGE|TENANT ROLE)\\s+.*"), Pattern.compile("\\s*DROP\\s+(ROLE|PACKAGE|TENANT ROLE)\\s+.*"), Pattern.compile("\\s*ADD\\s+(USER|TRUSTEDPROJECT|ACCOUNTPROVIDER|GROUP|TENANT USER|TENANT ROLE)\\s+.*"), Pattern.compile("\\s*ADD.*TO\\s+PACKAGE.*"), Pattern.compile("\\s*REMOVE\\s+(USER|TRUSTEDPROJECT|ACCOUNTPROVIDER|GROUP|TENANT USER|TENANT ROLE)\\s+.*"), Pattern.compile("\\s*REMOVE.*FROM\\s+PACKAGE.*"), Pattern.compile("\\s*ALTER\\s+(USER|GROUP)\\s+.*"), Pattern.compile("\\s*(DESCRIBE|DESC)\\s+(ROLE|PACKAGE|TENANT ROLE)\\s+.*"), Pattern.compile("\\s*DELETE\\s+PACKAGE\\s+.*"), Pattern.compile("\\s*(ALLOW|DISALLOW)\\s+PROJECT.*"), Pattern.compile("\\s*(INSTALL|UNINSTALL)\\s+PACKAGE.*"), Pattern.compile("\\s*SET\\s+(LABEL).*"), Pattern.compile("\\s*UNSET\\s+(LABEL).*")};

    public AuthorizationCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        SecurityManager sm = odps.projects().get().getSecurityManager();
        DefaultOutputWriter outputWriter = this.getContext().getOutputWriter();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("odps.namespace.schema", String.valueOf(this.getContext().isOdpsNamespaceSchema()));
        if (SetCommand.setMap.containsKey("odps.sql.allow.namespace.schema")) {
            settings.put("odps.sql.allow.namespace.schema", String.valueOf(this.getContext().isOdpsNamespaceSchema()));
        }
        settings.put("odps.default.schema", this.getContext().getSchemaName());
        SecurityManager.AuthorizationQueryInstance instance = sm.run(this.getCommandText(), Boolean.valueOf(false), null, settings);
        while (!instance.isTerminated()) {
            outputWriter.writeError("waiting...");
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(3L));
            }
            catch (InterruptedException e) {
                throw new UserInterruptException("User interrupted.");
            }
        }
        String result = instance.getResult();
        if (instance.getStatus() == SecurityManager.AuthorizationQueryStatus.FAILED) {
            throw new ODPSConsoleException("Failed: " + result);
        }
        if (StringUtils.isNullOrEmpty((String)result)) {
            outputWriter.writeResult("OK");
        } else {
            outputWriter.writeResult(result);
        }
    }

    public static AuthorizationCommand parse(String commandString, ExecutionContext sessionContext) {
        assert (commandString != null);
        String command = commandString.toUpperCase();
        for (Pattern pattern : PATTERNS) {
            if (!pattern.matcher(command).matches()) continue;
            return new AuthorizationCommand(commandString, sessionContext);
        }
        return null;
    }
}

