/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.Lot;
import apsara.odps.lot.WindowProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.WindowFunction;
import com.aliyun.odps.lot.operators.Operator;
import java.util.List;

public class Window
extends Operator {
    private List<Function> functions;

    public List<Function> getFunctions() {
        return this.functions;
    }

    public Window(List<Function> functions) {
        if (functions == null) {
            throw new ArgumentNullException("functions");
        }
        if (functions.size() == 0) {
            throw new IllegalArgumentException("You have to specify one window function at least for Window operator.");
        }
        this.functions = functions;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        WindowProtos.Window.Builder w = WindowProtos.Window.newBuilder();
        w.setId(this.getId());
        w.setParentId(this.getParents().get(0).getId());
        for (Function func : this.functions) {
            w.addFunctions(func.toProtoBuf());
        }
        builder.setWindow(w.build());
        return builder.build();
    }

    public static class Function {
        private WindowFunction function;
        private String alias;

        public Function(WindowFunction function, String alias) {
            if (function == null) {
                throw new ArgumentNullException("function");
            }
            if (alias == null) {
                throw new ArgumentNullException("alias");
            }
            this.function = function;
            this.alias = alias;
        }

        public WindowFunction getFunction() {
            return this.function;
        }

        public String getAlias() {
            return this.alias;
        }

        public WindowProtos.Window.Functions toProtoBuf() {
            WindowProtos.Window.Functions.Builder builder = WindowProtos.Window.Functions.newBuilder();
            builder.setAlias(this.alias);
            builder.setFunction(this.function.toProtoBuf());
            return builder.build();
        }
    }
}

