/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.DataSinkProtos;
import apsara.odps.lot.Lot;
import apsara.odps.lot.TableSinkProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.PartitionSpecification;
import com.aliyun.odps.lot.operators.DataSink;

public class TableSink
extends DataSink {
    private String project;
    private String table;
    private boolean overwrite;
    private PartitionSpecification partition;

    public String getProject() {
        return this.project;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public PartitionSpecification getPartition() {
        return this.partition;
    }

    public TableSink(String project, String table, boolean overwrite, PartitionSpecification partition) {
        if (project == null) {
            throw new ArgumentNullException("project");
        }
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        this.partition = partition;
        this.project = project;
        this.table = table;
        this.overwrite = overwrite;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        DataSinkProtos.DataSink.Builder ds = DataSinkProtos.DataSink.newBuilder();
        ds.setId(this.getId());
        ds.setParentId(this.getParents().get(0).getId());
        TableSinkProtos.TableSink.Builder ts = TableSinkProtos.TableSink.newBuilder();
        ts.setProject(this.project);
        ts.setTable(this.table);
        ts.setIsOverwrite(this.overwrite);
        if (this.partition != null) {
            ts.setPartition(this.partition.toProtoBuf());
        }
        ds.setTableSink(ts.build());
        builder.setDataSink(ds.build());
        return builder.build();
    }
}

