/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.Lot;
import apsara.odps.lot.StreamingTransformProtos;
import apsara.odps.lot.TransformProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Resource;
import com.aliyun.odps.lot.common.ScalarExpression;
import com.aliyun.odps.lot.common.Schema;
import com.aliyun.odps.lot.operators.Transform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamingTransform
extends Transform {
    private String cmd;
    private Map<String, String> properties = new HashMap<String, String>();

    public StreamingTransform(List<ScalarExpression> parameters, List<Resource> resources, Schema schema, String cmd) {
        super(parameters, resources, schema);
        if (cmd == null) {
            throw new ArgumentNullException("cmd");
        }
        this.cmd = cmd;
    }

    public String getCmd() {
        return this.cmd;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        if (key == null) {
            throw new ArgumentNullException("key");
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.properties.put(key, value);
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        TransformProtos.Transform.Builder trans = TransformProtos.Transform.newBuilder();
        trans.setId(this.getId());
        trans.setParentId(this.getParents().get(0).getId());
        for (ScalarExpression param : this.getParameters()) {
            trans.addParameters(param.toProtoBuf());
        }
        for (Resource res : this.getResources()) {
            TransformProtos.Transform.Resources.Builder rb = TransformProtos.Transform.Resources.newBuilder();
            rb.setProject(res.getProject());
            rb.setResourceName(res.getName());
            trans.addResources(rb.build());
        }
        StreamingTransformProtos.StreamingTransform.Builder st = StreamingTransformProtos.StreamingTransform.newBuilder();
        st.setCmd(this.cmd);
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            StreamingTransformProtos.StreamingTransform.Properties.Builder sb = StreamingTransformProtos.StreamingTransform.Properties.newBuilder();
            sb.setKey(prop.getKey());
            sb.setValue(prop.getValue());
            st.addProperties(sb.build());
        }
        trans.setStreamingTransform(st.build());
        trans.setSchema(this.getSchema().toProtoBuf());
        builder.setTransform(trans.build());
        return builder.build();
    }
}

