/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.operators;

import apsara.odps.lot.Lot;
import apsara.odps.lot.SelectProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.ScalarExpression;
import com.aliyun.odps.lot.operators.Operator;
import java.util.List;

public class Select
extends Operator {
    private List<Expression> expressions;

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public Select(List<Expression> expressions) {
        if (expressions == null) {
            throw new ArgumentNullException("expressions");
        }
        if (expressions.size() == 0) {
            throw new IllegalArgumentException("You have to specify one item at least for Select operator.");
        }
        this.expressions = expressions;
    }

    @Override
    public Lot.LogicalOperator toProtoBuf() {
        assert (this.getParents().size() == 1);
        Lot.LogicalOperator.Builder builder = Lot.LogicalOperator.newBuilder();
        SelectProtos.Select.Builder s = SelectProtos.Select.newBuilder();
        s.setId(this.getId());
        s.setParentId(this.getParents().get(0).getId());
        for (Expression expr : this.expressions) {
            SelectProtos.Select.Expressions.Builder e = SelectProtos.Select.Expressions.newBuilder();
            e.setExpression(expr.getExpression().toProtoBuf());
            e.setAlias(expr.getAlias());
            s.addExpressions(e.build());
        }
        builder.setSelect(s.build());
        return builder.build();
    }

    public static class Expression {
        private String alias;
        private ScalarExpression expression;

        public String getAlias() {
            return this.alias;
        }

        public ScalarExpression getExpression() {
            return this.expression;
        }

        public Expression(String alias, ScalarExpression expression) {
            if (alias == null) {
                throw new ArgumentNullException("alias");
            }
            if (expression == null) {
                throw new ArgumentNullException("expression");
            }
            this.alias = alias;
            this.expression = expression;
        }
    }
}

