/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.common;

import apsara.odps.lot.ExpressionProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.ScalarExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableValuedFunction {
    private String name;
    private String project;
    private List<ScalarExpression> parameters;
    private List<String> outputColumns;
    private Map<String, String> properties = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public String getProject() {
        return this.project;
    }

    public List<ScalarExpression> getParameters() {
        return this.parameters;
    }

    public List<String> getOutputColumns() {
        return this.outputColumns;
    }

    public void addProperties(String key, String value) {
        this.properties.put(key, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TableValuedFunction(String name, String project, List<ScalarExpression> parameters, List<String> outputColumns) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (project == null) {
            throw new ArgumentNullException("project");
        }
        this.parameters = parameters == null ? new ArrayList<ScalarExpression>() : parameters;
        if (outputColumns == null) {
            throw new ArgumentNullException("outputColumns");
        }
        if (outputColumns.size() == 0) {
            throw new IllegalArgumentException("You have to specify one output column at least.");
        }
        this.name = name;
        this.project = project;
        this.outputColumns = outputColumns;
    }

    public ExpressionProtos.TableValuedFunction toProtoBuf() {
        ExpressionProtos.TableValuedFunction.Builder builder = ExpressionProtos.TableValuedFunction.newBuilder();
        builder.setProject(this.project);
        builder.setName(this.name);
        for (ScalarExpression scalarExpression : this.parameters) {
            if (scalarExpression == null) {
                builder.addParameters(ScalarExpression.genNull());
                continue;
            }
            builder.addParameters(scalarExpression.toProtoBuf());
        }
        for (String string : this.outputColumns) {
            builder.addOutputColumns(string);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            ExpressionProtos.TableValuedFunction.Properties.Builder p = ExpressionProtos.TableValuedFunction.Properties.newBuilder();
            p.setKey((String)entry.getKey());
            p.setValue((String)entry.getValue());
            builder.addProperties(p.build());
        }
        return builder.build();
    }
}

