/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.common;

import apsara.odps.TypesProtos;
import apsara.odps.lot.SchemaProtos;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.IllegalOperationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Schema {
    private List<Column> columns = new ArrayList<Column>();
    private Set<String> names = new HashSet<String>();

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addColumn(OdpsType type, String name) throws IllegalOperationException {
        if (this.names.contains(name)) {
            throw new IllegalOperationException("You can't add columns with the same name '" + name + "'.");
        }
        this.columns.add(new Column(type, name));
    }

    public SchemaProtos.Schema toProtoBuf() {
        SchemaProtos.Schema.Builder builder = SchemaProtos.Schema.newBuilder();
        for (Column col : this.columns) {
            builder.addColumns(col.toProtoBuf());
        }
        return builder.build();
    }

    public static class Column {
        private OdpsType type;
        private String name;

        public Column(OdpsType type, String name) {
            if (name == null) {
                throw new ArgumentNullException("name");
            }
            this.type = type;
            this.name = name;
        }

        public OdpsType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public static TypesProtos.Type castType(OdpsType type) {
            switch (type) {
                case BIGINT: {
                    return TypesProtos.Type.Integer;
                }
                case DOUBLE: {
                    return TypesProtos.Type.Double;
                }
                case BOOLEAN: {
                    return TypesProtos.Type.Bool;
                }
                case DATETIME: {
                    return TypesProtos.Type.Datetime;
                }
                case STRING: {
                    return TypesProtos.Type.String;
                }
            }
            throw new RuntimeException("Invalid type of Schema.Column.");
        }

        public SchemaProtos.Schema.Columns toProtoBuf() {
            SchemaProtos.Schema.Columns.Builder builder = SchemaProtos.Schema.Columns.newBuilder();
            builder.setName(this.name);
            builder.setType(Column.castType(this.type));
            return builder.build();
        }
    }
}

