/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Task;
import com.aliyun.odps.task.SQLCostTask;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.task.SqlPlanTask;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.InteractiveQueryCommand;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.MultiClusterCommandBase;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import com.aliyun.openservices.odps.console.output.InstanceRunner;
import com.aliyun.openservices.odps.console.utils.FormatUtils;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import com.aliyun.openservices.odps.console.utils.QueryUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.jline.reader.UserInterruptException;

public class QueryCommand
extends MultiClusterCommandBase {
    static final String PMC_TASK_NAME = "console_pmc_task";
    private static final String PMC_TASK_CONSOLE_KEY = "odps.console.progressive.long.running.task";
    private String taskName = "";
    private boolean isSelectCommand = false;

    private Double getSQLInputSizeInGB() {
        try {
            String queryResult = this.runSQLCostTask();
            JsonObject node = new JsonParser().parse(queryResult).getAsJsonObject();
            if (!(node.has("Cost") && node.get("Cost").getAsJsonObject().has("SQL") && node.get("Cost").getAsJsonObject().get("SQL").getAsJsonObject().has("Input"))) {
                return null;
            }
            Double input = node.get("Cost").getAsJsonObject().get("SQL").getAsJsonObject().get("Input").getAsDouble();
            if (input != null) {
                return input / 1024.0 / 1024.0 / 1024.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String runSQLCostTask() throws OdpsException, ODPSConsoleException {
        String taskName = "console_cost_query_task_" + Calendar.getInstance().getTimeInMillis();
        SQLCostTask task = new SQLCostTask();
        task.setName(taskName);
        task.setQuery(this.getCommandText());
        HashMap taskConfig = QueryUtil.getTaskConfig();
        for (Map.Entry property : taskConfig.entrySet()) {
            task.setProperty((String)property.getKey(), (String)property.getValue());
        }
        Instance instance = this.getCurrentOdps().instances().create((Task)task);
        instance.waitForSuccess();
        return (String)instance.getTaskResults().get(task.getName());
    }

    private String getConfirmMessage() {
        return String.format("WARNING! Input data > %.3fGB, might be slow or expensive, proceed anyway (yes/no)?", this.getContext().getConfirmDataSize());
    }

    private boolean isConfirm() throws ODPSConsoleException {
        String inputStr;
        String prompt = this.getConfirmMessage();
        do {
            if ((inputStr = ODPSConsoleUtils.getOdpsConsoleReader().readConfirmation(prompt)) == null) {
                return false;
            }
            if (!"N".equals(inputStr = inputStr.trim().toUpperCase()) && !"NO".equals(inputStr)) continue;
            return false;
        } while (!"Y".equals(inputStr) && !"YES".equals(inputStr));
        return true;
    }

    private boolean confirmSQLInput() {
        Double threshold = this.getContext().getConfirmDataSize();
        if (threshold != null) {
            try {
                Double input = this.getSQLInputSizeInGB();
                if (input != null && input > threshold) {
                    return this.isConfirm();
                }
            }
            catch (ODPSConsoleException oDPSConsoleException) {
                // empty catch block
            }
        }
        return true;
    }

    protected String getTaskName(boolean isDryRun) {
        if (isDryRun) {
            return "console_sqlplan_task_" + Calendar.getInstance().getTimeInMillis();
        }
        return "console_query_task_" + Calendar.getInstance().getTimeInMillis();
    }

    public void run() throws OdpsException, ODPSConsoleException {
        ExecutionContext context = this.getContext();
        if (context.isInteractiveQuery()) {
            this.getWriter().writeError("Query will be executed in Interactive Mode.");
            new InteractiveQueryCommand(this.getCommandText(), this.getContext()).run();
            return;
        }
        if (this.isSelectCommand && context.isAsyncMode()) {
            this.getWriter().writeError("[async mode]: can't support select command.");
            return;
        }
        if (context.isInteractiveMode() && !this.confirmSQLInput()) {
            return;
        }
        boolean isDryRun = this.getContext().isDryRun();
        DefaultOutputWriter writer = context.getOutputWriter();
        int retryTime = this.isSelectCommand ? 1 : context.getRetryTimes();
        int n = retryTime = retryTime > 0 ? retryTime : 1;
        while (retryTime > 0) {
            SQLTask task = null;
            try {
                this.taskName = this.getTaskName(isDryRun);
                if (isDryRun) {
                    task = new SqlPlanTask(this.taskName, this.getCommandText());
                } else {
                    task = new SQLTask();
                    task.setName(this.taskName);
                    task.setQuery(this.getCommandText());
                }
                HashMap taskConfig = QueryUtil.getTaskConfig();
                if (!this.getContext().isMachineReadable()) {
                    HashMap settings = new HashMap();
                    settings.put("odps.sql.select.output.format", "HumanReadable");
                    QueryCommand.addSetting((Map)taskConfig, (Map)settings);
                }
                for (Map.Entry entry : taskConfig.entrySet()) {
                    task.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                this.runJob((Task)task);
                break;
            }
            catch (UserInterruptException e) {
                throw e;
            }
            catch (Exception e) {
                if (task instanceof SQLTask && QueryUtil.isOperatorDisabled((String)((SQLTask)task).getQuery())) {
                    String errorMessage = e.getMessage();
                    if (errorMessage.contains("ODPS-0110999")) {
                        throw new ODPSConsoleException(e.getMessage());
                    }
                    if (!errorMessage.contains("ODPS-")) {
                        throw new ODPSConsoleException("ODPS-0110999:" + e.getMessage());
                    }
                }
                if (--retryTime == 0) {
                    throw new ODPSConsoleException(e.getMessage(), (Throwable)e);
                }
                writer.writeError("retry " + retryTime);
                writer.writeDebug(StringUtils.stringifyException((Throwable)e));
            }
        }
        if (!this.isSelectCommand) {
            writer.writeError("OK");
        }
    }

    protected void reportResult(InstanceRunner runner) throws OdpsException, ODPSConsoleException {
        super.reportResult(runner);
        if (this.isSelectCommand && this.getContext().isUseInstanceTunnel()) {
            Long sessionMaxRow = this.getContext().getInstanceTunnelMaxRecord();
            String summary = sessionMaxRow != null ? String.format("A total of %d records fetched by instance tunnel. Max record number: %d", ((FormatUtils.FormattedResultSet)runner.getResult()).getRecordCount(), sessionMaxRow) : String.format("A total of %d records fetched by instance tunnel. Max record number: unlimited", ((FormatUtils.FormattedResultSet)runner.getResult()).getRecordCount());
            this.getContext().getOutputWriter().writeError(summary);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean isSelectCommand() {
        return this.isSelectCommand;
    }

    public QueryCommand(boolean isSelect, String commandText, ExecutionContext context) {
        super(commandText, context);
        this.isSelectCommand = isSelect;
    }

    public static QueryCommand parse(String commandString, ExecutionContext sessionContext) {
        boolean isSelect = false;
        if ((commandString = commandString.trim()).toUpperCase().matches("^SELECT[\\s\\S]*")) {
            isSelect = true;
        }
        if (!commandString.endsWith(";")) {
            commandString = commandString + ";";
        }
        return new QueryCommand(isSelect, commandString, sessionContext);
    }
}

