/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.RecordPrinter;
import com.aliyun.openservices.odps.console.utils.FormatUtils;
import com.aliyun.openservices.odps.console.utils.ODPSConsoleUtils;
import java.util.List;
import java.util.Map;

public class HumanReadableRecordPrinter
extends RecordPrinter {
    private String frame;
    private String title;
    private Map<String, Integer> width;

    protected HumanReadableRecordPrinter(TableSchema schema, ExecutionContext context) {
        super(schema, context);
        this.width = ODPSConsoleUtils.getDisplayWidth((List)schema.getColumns(), null, null);
        this.frame = ODPSConsoleUtils.makeOutputFrame(this.width);
        this.title = ODPSConsoleUtils.makeTitle((List)schema.getColumns(), this.width);
    }

    private String formatRecord(Record record, Map<String, Integer> width) {
        StringBuilder sb = new StringBuilder();
        sb.append("| ");
        for (int i = 0; i < record.getColumnCount(); ++i) {
            String res = null;
            res = this.context.isInteractiveQuery() && !this.context.isUseInstanceTunnel() && (record.get(i) == null || record.get(i).equals("\\N")) ? "NULL" : FormatUtils.formatField((Record)record, (int)i, (TypeInfo)record.getColumns()[i].getTypeInfo());
            sb.append(res);
            if (res.length() < width.get(record.getColumns()[i].getName())) {
                int extraLen = width.get(record.getColumns()[i].getName()) - res.length();
                while (extraLen-- > 0) {
                    sb.append(" ");
                }
            }
            sb.append(" | ");
        }
        return sb.toString();
    }

    @Override
    public void printFrame() {
        this.context.getOutputWriter().writeResult(this.frame);
    }

    @Override
    public void printTitle() {
        this.context.getOutputWriter().writeResult(this.title);
    }

    @Override
    public void printRecord(Record record) {
        this.context.getOutputWriter().writeResult(this.formatRecord(record, this.width));
    }
}

