/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console;

import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.RecordPrinter;
import com.aliyun.openservices.odps.console.utils.FormatUtils;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class CSVRecordPrinter
extends RecordPrinter {
    private CsvWriter csv;
    private TableSchema schema;

    protected CSVRecordPrinter(TableSchema schema, ExecutionContext context) {
        super(schema, context);
        this.schema = schema;
        this.csv = new CsvWriter(context.getOutputWriter().getResultStream(), ',', StandardCharsets.UTF_8);
        this.csv.setEscapeMode(2);
    }

    @Override
    public void printFrame() {
    }

    @Override
    public void printTitle() throws ODPSConsoleException {
        int n = this.schema.getColumns().size();
        String[] record = new String[n];
        for (int i = 0; i < n; ++i) {
            record[i] = this.schema.getColumn(i).getName();
        }
        try {
            this.csv.writeRecord(record, true);
            this.csv.flush();
        }
        catch (IOException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }

    @Override
    public void printRecord(Record record) throws ODPSConsoleException {
        String[] r = new String[record.getColumnCount()];
        for (int i = 0; i < record.getColumnCount(); ++i) {
            r[i] = FormatUtils.formatField((Record)record, (int)i, (TypeInfo)record.getColumns()[i].getTypeInfo());
        }
        try {
            this.csv.writeRecord(r, true);
            this.csv.flush();
        }
        catch (IOException e) {
            throw new ODPSConsoleException((Throwable)e);
        }
    }
}

