/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.VolumeException;
import com.aliyun.odps.VolumeFSFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class VolumeFSUtil {
    public static boolean isValidName(String src) {
        if (src == null) {
            return false;
        }
        if (!src.startsWith("/")) {
            return false;
        }
        String[] components = org.apache.hadoop.util.StringUtils.split((String)src, (char)'/');
        for (int i = 0; i < components.length; ++i) {
            String element = components[i];
            if (element.equals("~") || element.equals(".") || element.equals("..") || element.indexOf(":") >= 0 || element.indexOf("/") >= 0 || element.indexOf("\\") >= 0 || element.indexOf("\u0000") >= 0) {
                return false;
            }
            if (!element.isEmpty() || i == components.length - 1 || i == 0) continue;
            return false;
        }
        return true;
    }

    public static String getVolumeFromPath(Path path) throws VolumeException {
        if ((path = Path.getPathWithoutSchemeAndAuthority((Path)path)).depth() == 0) {
            throw new VolumeException("VolumeMissing", "No volume found!");
        }
        String p = path.toUri().getPath();
        String volume = p.split("/")[1];
        return volume;
    }

    public static String getVolumeFromPath(String pathStr) throws VolumeException {
        Path path = new Path(pathStr);
        return VolumeFSUtil.getVolumeFromPath(path);
    }

    public static String getExternalLocation(VolumeFSFile file) {
        if (file.getProperties() != null) {
            return file.getProperties().getOrDefault("external.location", null);
        }
        return null;
    }

    public static FileStatus transferFile(VolumeFSFile file) {
        String symlinkPath;
        if (file == null) {
            return null;
        }
        try {
            symlinkPath = StringUtils.isBlank((String)file.getSymlink()) ? VolumeFSUtil.getExternalLocation(file) : file.getSymlink();
        }
        catch (ReloadException e) {
            OdpsException exception = (OdpsException)e.getCause();
            System.err.println(file.getPath() + ": ls error: RequestId=" + exception.getRequestId() + ", ErrorCode=" + exception.getErrorCode() + ", ErrorMessage=" + exception.getMessage());
            return null;
        }
        Path symlink = symlinkPath == null ? null : new Path(symlinkPath);
        FileStatus fileStatus = new FileStatus(file.getLength().longValue(), file.getIsdir().booleanValue(), Objects.isNull(file.getBlockReplications()) ? 1 : file.getBlockReplications(), Objects.isNull(file.getBlockSize()) ? 524288L : file.getBlockSize(), Objects.isNull(file.getModificationTime()) ? 0L : file.getModificationTime().getTime(), Objects.isNull(file.getAccessTime()) ? 0L : file.getAccessTime().getTime(), com.aliyun.odps.utils.StringUtils.isNullOrEmpty((String)file.getPermission()) ? null : new FsPermission(Short.valueOf(file.getPermission(), 8).shortValue()), file.getOwner(), file.getGroup(), symlink, new Path("odps://" + file.getProject(), file.getPath()));
        return fileStatus;
    }

    public static boolean checkPathIsJustVolume(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.indexOf("/") == -1;
    }

    public static boolean checkPathIsRoot(String path) {
        if (StringUtils.isBlank((String)path)) {
            return false;
        }
        path = path.replaceAll("//", "/");
        return path.trim().equals("/");
    }

    public static FileStatus[] transferFiles(VolumeFSFile[] files) {
        if (files == null) {
            return null;
        }
        ArrayList<FileStatus> fileStatusList = new ArrayList<FileStatus>();
        for (VolumeFSFile file : files) {
            FileStatus fileStatus = VolumeFSUtil.transferFile(file);
            if (fileStatus == null) continue;
            fileStatusList.add(fileStatus);
        }
        return fileStatusList.toArray(new FileStatus[0]);
    }

    public static boolean isParentOf(Path parent, Path child) {
        URI parentURI = parent.toUri();
        String parentPath = parentURI.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        URI childURI = child.toUri();
        String childPath = childURI.getPath();
        return childPath.startsWith(parentPath);
    }

    public static void checkPath(String path) throws VolumeException {
        if (VolumeFSUtil.checkPathIsRoot(path)) {
            throw new VolumeException("VolumeMissing", "Root path is not supported this operation!");
        }
        if (VolumeFSUtil.checkPathIsJustVolume(path)) {
            throw new VolumeException("InvalidPath", "The path is just a volume!");
        }
        if (!VolumeFSUtil.isValidName(path)) {
            throw new VolumeException("InvalidPath", "The path contains illegal characters!");
        }
    }

    public static String[] getVolumeAndPath(String path) throws VolumeException {
        String[] parts = path.split("/", 3);
        if (parts.length == 3) {
            return new String[]{parts[1], parts[2]};
        }
        if (parts.length == 2) {
            return new String[]{parts[1], ""};
        }
        throw new VolumeException("Invalid path: " + path);
    }
}

