/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.VolumeException;
import com.aliyun.odps.volume.VolumeFSClient;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeFSInputStream
extends FSInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeFSInputStream.class);
    private VolumeFSClient volumeFSClient;
    private String path;
    private boolean closed = true;
    private Long fileLength;
    private long pos = 0L;
    private long blockSize;
    private String uuid;
    private Map<Long, Integer> cache = new ConcurrentHashMap<Long, Integer>();
    private InputStream in;
    private RandomAccessFile raf;
    private long curIndex = 0L;
    private File buffer_block_dir;
    private boolean isSeeked = false;
    private boolean isCache = false;
    private boolean seekOptimization;
    private static final Integer STATUS_DOWNLOADING = 0;
    private static final Integer STATUS_DOWNLOADED = 1;
    private ExecutorService executorService;
    private boolean isPreLoaded = false;

    public VolumeFSInputStream(String path, VolumeFSClient volumeClient, Long fileLength, Configuration conf) throws IOException {
        this.path = path;
        this.volumeFSClient = volumeClient;
        this.seekOptimization = conf.getBoolean("odps.volume.seek.optimization.enabled", false);
        if (this.seekOptimization) {
            this.blockSize = conf.getLong("odps.volume.block.size", 524288L);
        }
        this.fileLength = fileLength;
        this.closed = false;
        this.uuid = UUID.randomUUID().toString();
        this.buffer_block_dir = new File(conf.get("odps.volume.block.buffer.dir", "/tmp/volumefs/"));
        if (!this.buffer_block_dir.exists() && !this.buffer_block_dir.mkdirs()) {
            throw new IOException("Cannot create Volume block buffer directory: " + this.buffer_block_dir);
        }
        if (this.seekOptimization) {
            this.executorService = Executors.newFixedThreadPool(1);
        }
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkClosed();
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset");
        }
        if (pos > this.fileLength) {
            throw new EOFException("Attempted to seek or read past the end of the file");
        }
        this.pos = pos;
        this.isSeeked = true;
    }

    public synchronized long getPos() throws IOException {
        this.checkClosed();
        return this.pos;
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        this.checkClosed();
        this.seek(targetPos);
        try {
            this.in = this.getInputStream();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int len = this.read(buf, 0, 1);
        if (len == 1) {
            return buf[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
        if (this.pos >= this.fileLength) {
            return -1;
        }
        if (this.in == null || this.isSeeked || this.seekOptimization && this.isCache && this.pos / this.blockSize != this.curIndex) {
            this.in = this.getInputStream();
        }
        int avaliable = this.in.read(buf, off, len);
        this.pos += (long)avaliable;
        if (avaliable == len || this.pos >= this.fileLength) {
            return avaliable;
        }
        IOUtils.closeQuietly((InputStream)this.in);
        this.in = null;
        return avaliable + this.read(buf, off + avaliable, len - avaliable);
    }

    private synchronized InputStream getInputStream() throws IOException {
        if (this.seekOptimization) {
            long index = this.pos / this.blockSize;
            if (!this.isPreLoaded) {
                this.isPreLoaded = true;
                this.seekOptimization();
            }
            if (this.in != null && index == this.curIndex && this.isCache && this.isSeeked) {
                this.in = Channels.newInputStream(this.raf.getChannel().position(this.pos - this.curIndex * this.blockSize));
                return this.in;
            }
            IOUtils.closeQuietly((InputStream)this.in);
            IOUtils.closeQuietly((Closeable)this.raf);
            if (this.cache.get(index) != STATUS_DOWNLOADED) {
                this.curIndex = index;
                return this.getRemoteInputStream();
            }
            File blockFile = new File(this.buffer_block_dir, this.getBlockFileName(index));
            if (!blockFile.exists()) {
                this.cache.remove(index);
                this.curIndex = index;
                return this.getRemoteInputStream();
            }
            return this.getLocalInputStream(index);
        }
        IOUtils.closeQuietly((InputStream)this.in);
        return this.getRemoteInputStream();
    }

    private synchronized InputStream getLocalInputStream(long index) throws FileNotFoundException, IOException {
        if (!this.seekOptimization) {
            return null;
        }
        this.isCache = true;
        File blockFile = new File(this.buffer_block_dir, this.getBlockFileName(index));
        this.raf = new RandomAccessFile(blockFile, "r");
        return Channels.newInputStream(this.raf.getChannel().position(this.pos - this.curIndex * this.blockSize));
    }

    private synchronized InputStream getRemoteInputStream() throws IOException {
        this.isSeeked = false;
        this.isCache = false;
        try {
            return this.volumeFSClient.openInputStream(this.path, this.pos, this.fileLength - 1L);
        }
        catch (VolumeException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void seekOptimization() {
        long i;
        long totalBlockNum = (long)Math.ceil(this.fileLength.doubleValue() / (double)this.blockSize);
        if (totalBlockNum > 2L) {
            for (i = 2L; i < totalBlockNum; ++i) {
                if (this.cache.containsKey(i)) continue;
                this.cache.put(i, STATUS_DOWNLOADING);
                this.executorService.submit(new SeekOptimizationWorker(i));
            }
        }
        for (i = totalBlockNum - 1L; i >= 0L; --i) {
            if (this.cache.containsKey(i)) continue;
            this.cache.put(i, STATUS_DOWNLOADING);
            this.executorService.submit(new SeekOptimizationWorker(i));
        }
    }

    public synchronized int available() throws IOException {
        this.checkClosed();
        return (int)(this.fileLength - this.pos);
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            IOUtils.closeQuietly((InputStream)this.in);
            IOUtils.closeQuietly((Closeable)this.raf);
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
    }

    private synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    private String getBlockFileName(long index) {
        return "volumefs-input-block-" + this.uuid + "-" + index + ".tmp";
    }

    class SeekOptimizationWorker
    implements Runnable {
        private Long index;

        SeekOptimizationWorker(Long index) {
            this.index = index;
        }

        @Override
        public void run() {
            long start = this.index * VolumeFSInputStream.this.blockSize;
            if (start > VolumeFSInputStream.this.fileLength - 1L) {
                return;
            }
            long end = Math.min((this.index + 1L) * VolumeFSInputStream.this.blockSize - 1L, VolumeFSInputStream.this.fileLength - 1L);
            File blockFile = new File(VolumeFSInputStream.this.buffer_block_dir, VolumeFSInputStream.this.getBlockFileName(this.index));
            blockFile.deleteOnExit();
            try {
                VolumeFSInputStream.this.volumeFSClient.downloadFile(VolumeFSInputStream.this.path, start, end, blockFile, false);
                VolumeFSInputStream.this.cache.put(this.index, STATUS_DOWNLOADED);
            }
            catch (VolumeException e) {
                VolumeFSInputStream.this.cache.remove(this.index);
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

