/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.volume.VolumeFSClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;

public class ExternalVolumeFSOutputStream
extends OutputStream {
    private String path;
    private File file;
    private FileOutputStream outputStream;
    private VolumeFSClient volumeClient;

    public ExternalVolumeFSOutputStream(String path, VolumeFSClient volumeClient, boolean overwrite, Configuration conf) throws IOException {
        this.volumeClient = volumeClient;
        this.path = path;
        File bufferBlockDir = new File(conf.get("odps.volume.block.buffer.dir", "/tmp/volumefs/"));
        if (!bufferBlockDir.exists() && !bufferBlockDir.mkdirs()) {
            throw new IOException("Cannot create Volume block buffer directory: " + bufferBlockDir);
        }
        String uuid = UUID.randomUUID().toString();
        String tempFileName = bufferBlockDir.getPath() + uuid;
        if (!overwrite) {
            try {
                volumeClient.downloadFileFromExternalVolume(path, tempFileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.file = new File(tempFileName);
        this.outputStream = new FileOutputStream(this.file, true);
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        try {
            this.volumeClient.uploadFileToExternalVolume(this.path, Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            throw new IOException("upload file " + this.path + "failed!", e);
        }
        finally {
            this.file.delete();
        }
    }
}

