/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.volume.VolumeFSClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSInputStream;

public class ExternalVolumeFSInputStream
extends FSInputStream {
    private FileInputStream input;
    private long position;
    private File tempFile;

    public ExternalVolumeFSInputStream(String path, VolumeFSClient volumeClient, Configuration conf) throws IOException {
        String uuid = UUID.randomUUID().toString();
        File bufferBlockDir = new File(conf.get("odps.volume.block.buffer.dir", "/tmp/volumefs/"));
        if (!bufferBlockDir.exists() && !bufferBlockDir.mkdirs()) {
            throw new IOException("Cannot create Volume block buffer directory: " + bufferBlockDir);
        }
        String tempFileName = bufferBlockDir.getPath() + uuid;
        try {
            volumeClient.downloadFileFromExternalVolume(path, bufferBlockDir.getPath() + uuid);
        }
        catch (Exception e) {
            throw new IOException("download " + path + " error! ", e);
        }
        this.tempFile = new File(tempFileName);
        this.input = new FileInputStream(this.tempFile);
    }

    public int read() throws IOException {
        int result = this.input.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    public void close() throws IOException {
        this.input.close();
        this.tempFile.delete();
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Position cannot be negative");
        }
        if (pos > this.input.getChannel().size()) {
            throw new IllegalArgumentException("Position cannot be greater than the file size");
        }
        this.position = pos;
        this.input.getChannel().position(pos);
    }

    public long getPos() {
        return this.position;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        if (targetPos < 0L) {
            throw new IllegalArgumentException("Target position cannot be negative");
        }
        if (targetPos > this.input.getChannel().size()) {
            throw new IllegalArgumentException("Target position cannot be greater than the file size");
        }
        long oldPos = this.position;
        try {
            this.input.getChannel().position(targetPos);
            this.position = targetPos;
            return true;
        }
        catch (IOException e) {
            this.input.getChannel().position(oldPos);
            this.position = oldPos;
            return false;
        }
    }
}

