/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.fs;

import com.aliyun.odps.Odps;
import com.aliyun.odps.VolumeException;
import com.aliyun.odps.VolumeFSFile;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunAccount;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.odps.volume.ExternalVolumeFSInputStream;
import com.aliyun.odps.volume.ExternalVolumeFSOutputStream;
import com.aliyun.odps.volume.VolumeFSClient;
import com.aliyun.odps.volume.VolumeFSInputStream;
import com.aliyun.odps.volume.VolumeFSOutputStream;
import com.aliyun.odps.volume.VolumeFSUtil;
import com.aliyun.odps.volume.protocol.VolumeFSErrorMessageGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeFileSystem.class);
    private String project;
    private String homeVolume;
    private short defaultReplication;
    private Path workingDir;
    private URI uri;
    private VolumeFSClient volumeClient;

    public String getScheme() {
        return "odps";
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        conf.addResource("volumefs-site.xml");
        super.initialize(uri, conf);
        this.setConf(conf);
        this.checkURI(uri);
        this.project = this.resolveProject(uri);
        this.volumeClient = this.createVolumeClient(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.homeVolume = this.getHomeVolume(conf);
        this.workingDir = this.getHomeDirectory();
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
    }

    private String getHomeVolume(Configuration conf) {
        String defaultVolume = conf.get("odps.home.volume");
        if (defaultVolume != null) {
            return defaultVolume;
        }
        return "user";
    }

    private String resolveProject(URI uri) {
        return uri.getAuthority();
    }

    private void checkURI(URI uri) throws IOException {
        String authority = uri.getAuthority();
        if (authority == null) {
            throw new IOException("Incomplete ODPS URI, no project: " + uri);
        }
    }

    private VolumeFSClient createVolumeClient(Configuration conf) throws IOException {
        String accessId = conf.get("odps.access.id");
        String accessKey = conf.get("odps.access.key");
        if (accessId == null || accessKey == null) {
            throw new IOException("Incomplete config, no accessId or accessKey");
        }
        String serviceEndpoint = conf.get("odps.service.endpoint");
        String tunnelEndpoint = conf.get("odps.tunnel.endpoint");
        if (serviceEndpoint == null) {
            throw new IOException("Incomplete config, no odps.service.endpoint");
        }
        AliyunAccount account = new AliyunAccount(accessId, accessKey);
        Odps odps = new Odps((Account)account);
        String restClientRetryTime = conf.get("odps.restclient.retrytime");
        if (!StringUtils.isNullOrEmpty((String)restClientRetryTime)) {
            odps.getRestClient().setRetryTimes(Integer.parseInt(restClientRetryTime));
        }
        odps.setEndpoint(serviceEndpoint);
        return new VolumeFSClient(odps, this.project, serviceEndpoint, tunnelEndpoint, conf);
    }

    public Path getHomeDirectory() {
        return new Path("/" + this.homeVolume, System.getProperty("user.name"));
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path absF = this.fixRelativePart(f);
        String filePath = this.getPathName(absF);
        if (!this.exists(absF)) {
            throw new FileNotFoundException(filePath);
        }
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException(VolumeFSErrorMessageGenerator.isADirectory(filePath));
        }
        if (fileStatus.isSymlink()) {
            return new FSDataInputStream((InputStream)((Object)new ExternalVolumeFSInputStream(filePath, this.volumeClient, this.getConf())));
        }
        return new FSDataInputStream((InputStream)((Object)new VolumeFSInputStream(filePath, this.volumeClient, fileStatus.getLen(), this.getConf())));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path absF = this.fixRelativePart(f);
        String filePath = this.getPathName(absF);
        if (!VolumeFSUtil.isValidName(filePath)) {
            throw new IllegalArgumentException(VolumeFSErrorMessageGenerator.isNotAValidODPSVolumeFSFilename(filePath));
        }
        if (VolumeFSUtil.checkPathIsJustVolume(filePath)) {
            throw new IOException(VolumeFSErrorMessageGenerator.theOpreationIsNotAllowed("Create file in the root path!"));
        }
        try {
            if (this.volumeClient.isExternalVolume(VolumeFSUtil.getVolumeFromPath(absF))) {
                return new FSDataOutputStream((OutputStream)new ExternalVolumeFSOutputStream(filePath, this.volumeClient, overwrite, this.getConf()), this.statistics);
            }
            return new FSDataOutputStream((OutputStream)new VolumeFSOutputStream(filePath, this.volumeClient, permission, overwrite, replication, blockSize, progress), this.statistics);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(filePath, e);
        }
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        if (!this.exists(absSrc)) {
            throw new FileNotFoundException("Source path " + src + " does not exist");
        }
        if (this.isDirectory(absDst)) {
            absDst = new Path(absDst, absSrc.getName());
        }
        if (this.exists(absDst)) {
            throw new FileAlreadyExistsException("Destination path " + dst + " already exists");
        }
        if (absDst.getParent() != null && !this.exists(absDst.getParent())) {
            throw new FileNotFoundException(VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(absDst.getParent().toString()));
        }
        if (VolumeFSUtil.isParentOf(absSrc, absDst)) {
            throw new IOException("Cannot rename " + absSrc + " under itself : " + absDst);
        }
        String srcPath = this.getPathName(absSrc);
        String dstPath = this.getPathName(absDst);
        try {
            return this.volumeClient.rename(srcPath, dstPath);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(srcPath, e);
        }
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        String filePath;
        block6: {
            this.statistics.incrementWriteOps(1);
            Path absF = this.fixRelativePart(f);
            filePath = this.getPathName(absF);
            if ("/".equalsIgnoreCase(filePath.replaceAll("//", "/").trim()) && !recursive) {
                throw new IOException("Non recursive delete is not allowed on root path");
            }
            try {
                this.getFileStatus(absF);
            }
            catch (IOException e) {
                if (!(e instanceof FileNotFoundException)) break block6;
                return false;
            }
        }
        try {
            return this.volumeClient.delete(filePath, recursive);
        }
        catch (VolumeException e) {
            IOException ioe = this.wrapExceptions(filePath, e);
            if (ioe instanceof FileNotFoundException) {
                return false;
            }
            this.logException(e);
            throw ioe;
        }
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        VolumeFSFile[] files;
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        String filePath = this.getPathName(absF);
        try {
            files = this.volumeClient.getFileInfosByPath(filePath);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(filePath, e);
        }
        return VolumeFSUtil.transferFiles(files);
    }

    public void setWorkingDirectory(Path new_dir) {
        Path dir = this.fixRelativePart(new_dir);
        String result = dir.toUri().getPath();
        if (!VolumeFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid Volume directory name " + result);
        }
        this.workingDir = dir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(f);
        String filePath = this.getPathName(absF);
        try {
            return this.volumeClient.mkdirs(filePath);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(filePath, e);
        }
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path absF = this.fixRelativePart(src);
        String filePath = this.getPathName(absF);
        try {
            return this.volumeClient.setReplication(filePath, replication);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(filePath, e);
        }
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        VolumeFSFile file;
        this.statistics.incrementReadOps(1);
        Path absF = this.fixRelativePart(f);
        String filePath = this.getPathName(absF);
        try {
            file = this.volumeClient.getFileInfo(filePath);
        }
        catch (VolumeException e) {
            this.logException(e);
            throw this.wrapExceptions(filePath, e);
        }
        return VolumeFSUtil.transferFile(file);
    }

    public FsStatus getStatus(Path p) throws IOException {
        return new FsStatus(0L, 0L, 0L);
    }

    private IOException wrapExceptions(String path, VolumeException e) {
        if ("NoSuchPath".equalsIgnoreCase(e.getErrCode())) {
            return new FileNotFoundException(VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
        }
        if ("InvalidPath".equalsIgnoreCase(e.getErrCode())) {
            throw new IllegalArgumentException(VolumeFSErrorMessageGenerator.isNotAValidODPSVolumeFSFilename(path));
        }
        if ("NotAcceptableOperation".equalsIgnoreCase(e.getErrCode())) {
            throw new UnsupportedOperationException(e.getMessage());
        }
        if ("PathAlreadyExists".equalsIgnoreCase(e.getErrCode())) {
            return new FileAlreadyExistsException(e.getMessage());
        }
        if ("ParentNotDirectory".equalsIgnoreCase(e.getErrCode())) {
            return new ParentNotDirectoryException(e.getMessage());
        }
        return new IOException(e.getMessage(), e);
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = file.toUri().getPath();
        if (!VolumeFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid VolumeFS filename.");
        }
        return result;
    }

    private void logException(VolumeException e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }
}

