/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.common.CommandUtils;
import com.aliyun.openservices.odps.console.output.DefaultOutputWriter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShowAutoMvCommand
extends AbstractCommand {
    private static final Pattern SHOW_PATTERN = Pattern.compile("\\s*SHOW\\s+AUTOMVMETA\\s*", 2);

    public ShowAutoMvCommand(String commandText, ExecutionContext context) {
        super(commandText, context);
    }

    protected void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        Map map = odps.projects().get().showAutoMvMeta();
        if (map == null || map.isEmpty()) {
            return;
        }
        DefaultOutputWriter writer = this.getContext().getOutputWriter();
        writer.writeResult("");
        if (map.containsKey("fileSize")) {
            writer.writeResult("fileSize: " + Long.parseLong((String)map.get("fileSize")));
        }
        if (map.containsKey("tableNum")) {
            writer.writeResult("num: " + Long.parseLong((String)map.get("tableNum")));
        }
        if (map.containsKey("updateTime")) {
            String updateTime = (String)map.get("updateTime");
            writer.writeResult("updateTime: " + (updateTime.equals("-1") ? "-1" : CommandUtils.longToDateTime(updateTime)));
        }
        if (map.containsKey("lastAutoMvCreationStartTime")) {
            String lastAutoMvCreationStartTime = (String)map.get("lastAutoMvCreationStartTime");
            writer.writeResult("lastAutoMvCreationStartTime: " + (lastAutoMvCreationStartTime.equals("-1") ? "-1" : CommandUtils.longToDateTime(lastAutoMvCreationStartTime)));
        }
        if (map.containsKey("lastAutoMvCreationFinishTime")) {
            String lastAutoMvCreationFinishTime = (String)map.get("lastAutoMvCreationFinishTime");
            writer.writeResult("lastAutoMvCreationFinishTime: " + (lastAutoMvCreationFinishTime.equals("-1") ? "-1" : CommandUtils.longToDateTime(lastAutoMvCreationFinishTime)));
        }
        writer.writeResult("\nOK");
    }

    public static ShowAutoMvCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        Matcher matcher = SHOW_PATTERN.matcher(commandString);
        if (!matcher.matches()) {
            return null;
        }
        return new ShowAutoMvCommand(commandString, sessionContext);
    }
}

