/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.ExportProjectUtil;
import java.io.PrintStream;

public class ExportProjectCommand
extends AbstractCommand {
    public static final String[] HELP_TAGS = new String[]{"export", "project"};
    private String projectName;
    private String localPath;
    private String options;

    public static void printUsage(PrintStream stream) {
        stream.println("Usage: export <projectname> <local_path>  [-rftpd]");
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getOptions() {
        return this.options;
    }

    public ExportProjectCommand(String commandText, ExecutionContext context, String projectName, String localPath, String options) {
        super(commandText, context);
        this.projectName = projectName;
        this.localPath = localPath;
        this.options = options;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        Odps odps = this.getCurrentOdps();
        odps.setDefaultProject(this.projectName);
        ExportProjectUtil.exportProject((Odps)odps, (String)this.localPath, (ExecutionContext)this.getContext(), (String)this.getOptions());
    }

    public static ExportProjectCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (commandString.trim().toUpperCase().startsWith("EXPORT")) {
            String[] temp = commandString.trim().split("\\s+");
            if (temp.length == 3) {
                return new ExportProjectCommand(commandString, sessionContext, temp[1], temp[2], "-rftpd");
            }
            if (temp.length == 4) {
                return new ExportProjectCommand(commandString, sessionContext, temp[1], temp[2], temp[3]);
            }
        }
        return null;
    }
}

