/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.odps.console.pub;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.Table;
import com.aliyun.openservices.odps.console.ExecutionContext;
import com.aliyun.openservices.odps.console.ODPSConsoleException;
import com.aliyun.openservices.odps.console.commands.AbstractCommand;
import com.aliyun.openservices.odps.console.utils.Coordinate;
import java.util.Iterator;

public class ExportMetaCommand
extends AbstractCommand {
    static final String SHOW_PARTITIONS = "SHOW_PARTITIONS";
    static final String SHOW_TABLES = "SHOW_TABLES";
    static final String DESC_TABLES = "DESC_TABLES";
    private String commandMark = "";
    private String tableName = "";

    public String getTableName() {
        return this.tableName;
    }

    public String getCommandMark() {
        return this.commandMark;
    }

    public ExportMetaCommand(String commandText, ExecutionContext context, String tableName, String commandMark) {
        super(commandText, context);
        this.tableName = tableName;
        this.commandMark = commandMark;
    }

    public void run() throws OdpsException, ODPSConsoleException {
        if (this.getContext().isSchemaMode()) {
            throw new ODPSConsoleException("ExportMetaCommand not support schema mode");
        }
        String project = this.getCurrentProject();
        Odps odps = this.getCurrentOdps();
        if (SHOW_PARTITIONS.equals(this.commandMark)) {
            Table table = odps.tables().get(project, this.tableName);
            table.reload();
            Iterator partitionList = table.getPartitionIterator();
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            while (partitionList.hasNext()) {
                Partition partition = (Partition)partitionList.next();
                String partition_spec = partition.getPartitionSpec().toString();
                builder.append(partition_spec.replace('\'', '\"'));
                if (!partitionList.hasNext()) continue;
                builder.append(",\n");
            }
            builder.append("]");
            System.out.println(builder.toString());
        } else if (SHOW_TABLES.equals(this.commandMark)) {
            Iterator tableList = odps.tables().iterator(project);
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            while (tableList.hasNext()) {
                Table info = (Table)tableList.next();
                builder.append("\"" + info.getOwner() + ":" + info.getName() + "\"");
                if (!tableList.hasNext()) continue;
                builder.append(",\n");
            }
            builder.append("]");
            System.out.println(builder.toString());
        } else if (DESC_TABLES.equals(this.commandMark)) {
            Coordinate coordinate = Coordinate.getCoordinateABC((String)this.tableName);
            coordinate.interpretByCtx(this.getContext());
            String projectName = coordinate.getProjectName();
            if (projectName == null) {
                projectName = project;
            }
            String realTableName = coordinate.getObjectName();
            Table table = odps.tables().get(projectName, realTableName);
            table.reload();
            System.out.println(table.getJsonSchema());
        }
    }

    public static ExportMetaCommand parse(String commandString, ExecutionContext sessionContext) throws ODPSConsoleException {
        if (sessionContext.isJson()) {
            String[] splits = commandString.trim().split(" ");
            if (commandString.toUpperCase().matches("\\s*SHOW\\s+PARTITIONS.*") && splits.length == 3) {
                return new ExportMetaCommand(commandString, sessionContext, splits[2], SHOW_PARTITIONS);
            }
            if (commandString.toUpperCase().matches("\\s*SHOW\\s+TABLES.*") && splits.length == 2) {
                return new ExportMetaCommand(commandString, sessionContext, "", SHOW_TABLES);
            }
            if (commandString.toUpperCase().matches("\\s*DESC.*") && splits.length == 2) {
                return new ExportMetaCommand(commandString, sessionContext, splits[1], DESC_TABLES);
            }
        }
        return null;
    }
}

